/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project;

import java.util.Arrays;
import java.util.List;
import org.sonar.core.util.stream.MoreCollectors;

public enum Visibility {
    PRIVATE(true, "private"),
    PUBLIC(false, "public");

    private static final List<String> LABELS;
    private final boolean isPrivate;
    private final String label;

    private Visibility(boolean isPrivate, String label) {
        this.isPrivate = isPrivate;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    public static String getLabel(boolean isPrivate) {
        return Arrays.stream(Visibility.values()).filter(v -> v.isPrivate == isPrivate).map(Visibility::getLabel).findAny().orElseThrow(() -> new IllegalStateException("Invalid visibility boolean '" + isPrivate + "'"));
    }

    public static boolean isPrivate(String label) {
        return Arrays.stream(Visibility.values()).filter(v -> v.label.equals(label)).map(Visibility::isPrivate).findAny().orElseThrow(() -> new IllegalStateException("Invalid visibility label '" + label + "'"));
    }

    public static List<String> getLabels() {
        return LABELS;
    }

    static {
        LABELS = (List)Arrays.stream(Visibility.values()).map(Visibility::getLabel).collect(MoreCollectors.toList((int)Visibility.values().length));
    }
}

