/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.platform.PluginInfo;
import org.sonar.server.plugins.PluginDownloader;
import org.sonar.server.plugins.PluginUninstaller;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.updatecenter.common.Plugin;

public class PendingAction
implements PluginsWsAction {
    private static final String ARRAY_INSTALLING = "installing";
    private static final String ARRAY_REMOVING = "removing";
    private static final String ARRAY_UPDATING = "updating";
    private final UserSession userSession;
    private final PluginDownloader pluginDownloader;
    private final ServerPluginRepository installer;
    private final PluginWSCommons pluginWSCommons;
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final PluginUninstaller pluginUninstaller;

    public PendingAction(UserSession userSession, PluginDownloader pluginDownloader, ServerPluginRepository installer, PluginUninstaller pluginUninstaller, PluginWSCommons pluginWSCommons, UpdateCenterMatrixFactory updateCenterMatrixFactory) {
        this.userSession = userSession;
        this.pluginDownloader = pluginDownloader;
        this.installer = installer;
        this.pluginUninstaller = pluginUninstaller;
        this.pluginWSCommons = pluginWSCommons;
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("pending").setDescription("Get the list of plugins which will either be installed or removed at the next startup of the SonarQube instance, sorted by plugin name.<br/>Require 'Administer System' permission.").setSince("5.2").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-pending_plugins.json"));
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        ImmutableMap<String, Plugin> compatiblePluginsByKey = PluginWSCommons.compatiblePluginsByKey(this.updateCenterMatrixFactory);
        JsonWriter jsonWriter = response.newJsonWriter();
        jsonWriter.beginObject();
        this.writePlugins(jsonWriter, (Map<String, Plugin>)compatiblePluginsByKey);
        jsonWriter.endObject();
        jsonWriter.close();
    }

    private void writePlugins(JsonWriter json, Map<String, Plugin> compatiblePluginsByKey) {
        Collection<PluginInfo> uninstalledPlugins = this.pluginUninstaller.getUninstalledPlugins();
        Collection<PluginInfo> downloadedPlugins = this.pluginDownloader.getDownloadedPlugins();
        Collection<PluginInfo> installedPlugins = this.installer.getPluginInfos();
        MatchPluginKeys matchPluginKeys = new MatchPluginKeys((Collection)FluentIterable.from(installedPlugins).transform((Function)PluginInfoToKey.INSTANCE).toSet());
        ArrayList<PluginInfo> newPlugins = new ArrayList<PluginInfo>();
        ArrayList<PluginInfo> updatedPlugins = new ArrayList<PluginInfo>();
        for (PluginInfo pluginInfo : downloadedPlugins) {
            if (matchPluginKeys.apply(pluginInfo)) {
                updatedPlugins.add(pluginInfo);
                continue;
            }
            newPlugins.add(pluginInfo);
        }
        this.pluginWSCommons.writePluginInfoList(json, newPlugins, compatiblePluginsByKey, ARRAY_INSTALLING, null);
        this.pluginWSCommons.writePluginInfoList(json, updatedPlugins, compatiblePluginsByKey, ARRAY_UPDATING, null);
        this.pluginWSCommons.writePluginInfoList(json, uninstalledPlugins, compatiblePluginsByKey, ARRAY_REMOVING, null);
    }

    private static class MatchPluginKeys
    implements Predicate<PluginInfo> {
        private final Set<String> pluginKeys;

        private MatchPluginKeys(Collection<String> pluginKeys) {
            this.pluginKeys = ImmutableSet.copyOf(pluginKeys);
        }

        public boolean apply(@Nonnull PluginInfo input) {
            return this.pluginKeys.contains(input.getKey());
        }
    }

    private static enum PluginInfoToKey implements Function<PluginInfo, String>
    {
        INSTANCE;


        public String apply(@Nonnull PluginInfo input) {
            return input.getKey();
        }
    }
}

