/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.UriReader;
import org.sonar.api.utils.log.Loggers;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.UpdateCenterDeserializer;

@org.sonar.api.Properties(value={@Property(key="sonar.updatecenter.activate", defaultValue="true", name="Enable Update Center", category="Update Center", project=false, global=false, type=PropertyType.BOOLEAN), @Property(key="sonar.updatecenter.url", defaultValue="https://update.sonarsource.org/update-center.properties", name="Update Center URL", category="Update Center", project=false, global=false)})
public class UpdateCenterClient {
    public static final String URL_PROPERTY = "sonar.updatecenter.url";
    public static final int PERIOD_IN_MILLISECONDS = 3600000;
    private final URI uri;
    private final UriReader uriReader;
    private final boolean isActivated;
    private UpdateCenter pluginCenter = null;
    private long lastRefreshDate = 0L;

    public UpdateCenterClient(UriReader uriReader, Configuration config) throws URISyntaxException {
        this.uriReader = uriReader;
        this.uri = new URI((String)config.get(URL_PROPERTY).get());
        this.isActivated = (Boolean)config.getBoolean("sonar.updatecenter.activate").get();
        Loggers.get(this.getClass()).info("Update center: " + uriReader.description(this.uri));
    }

    public Optional<UpdateCenter> getUpdateCenter() {
        return this.getUpdateCenter(false);
    }

    public Optional<UpdateCenter> getUpdateCenter(boolean forceRefresh) {
        if (!this.isActivated) {
            return Optional.absent();
        }
        if (this.pluginCenter == null || forceRefresh || this.needsRefresh()) {
            this.pluginCenter = this.init();
            this.lastRefreshDate = System.currentTimeMillis();
        }
        return Optional.fromNullable((Object)this.pluginCenter);
    }

    public Date getLastRefreshDate() {
        return this.lastRefreshDate > 0L ? new Date(this.lastRefreshDate) : null;
    }

    private boolean needsRefresh() {
        return this.lastRefreshDate + 3600000L < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateCenter init() {
        InputStream input = null;
        try {
            String content = this.uriReader.readString(this.uri, StandardCharsets.UTF_8);
            Properties properties = new Properties();
            input = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
            properties.load(input);
            UpdateCenter updateCenter = new UpdateCenterDeserializer(UpdateCenterDeserializer.Mode.PROD, true).fromProperties(properties);
            IOUtils.closeQuietly((InputStream)input);
            return updateCenter;
        }
        catch (Exception e) {
            Loggers.get(this.getClass()).error("Fail to connect to update center", (Throwable)e);
            UpdateCenter updateCenter = null;
            return updateCenter;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }
}

