/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import java.io.File;
import java.util.function.Predicate;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.ZipUtils;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.core.util.FileUtils;
import org.sonar.server.platform.ServerFileSystem;

@ServerSide
public class ServerPluginJarExploder
extends PluginJarExploder {
    private final ServerFileSystem fs;

    public ServerPluginJarExploder(ServerFileSystem fs) {
        this.fs = fs;
    }

    public ExplodedPlugin explode(PluginInfo pluginInfo) {
        File toDir = new File(this.fs.getDeployedPluginsDir(), pluginInfo.getKey());
        try {
            org.apache.commons.io.FileUtils.forceMkdir((File)toDir);
            FileUtils.cleanDirectory((File)toDir);
            File jarSource = pluginInfo.getNonNullJarFile();
            File jarTarget = new File(toDir, jarSource.getName());
            org.apache.commons.io.FileUtils.copyFile((File)jarSource, (File)jarTarget);
            ZipUtils.unzip((File)jarSource, (File)toDir, (Predicate)this.newLibFilter());
            return this.explodeFromUnzippedDir(pluginInfo.getKey(), jarTarget, toDir);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to unzip plugin [%s] %s to %s", pluginInfo.getKey(), pluginInfo.getNonNullJarFile().getAbsolutePath(), toDir.getAbsolutePath()), e);
        }
    }
}

