/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.core.platform.PluginInfo;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.PluginReferentialManifestConverter;
import org.sonar.updatecenter.common.Version;

public class PluginReferentialMetadataConverter {
    private PluginReferentialMetadataConverter() {
    }

    public static PluginReferential getInstalledPluginReferential(Collection<PluginInfo> infos) {
        List<PluginManifest> pluginManifestList = PluginReferentialMetadataConverter.getPluginManifestList(infos);
        return PluginReferentialManifestConverter.fromPluginManifests(pluginManifestList);
    }

    private static List<PluginManifest> getPluginManifestList(Collection<PluginInfo> metadata) {
        ArrayList pluginManifestList = Lists.newArrayList();
        for (PluginInfo plugin : metadata) {
            pluginManifestList.add(PluginReferentialMetadataConverter.toPluginManifest(plugin));
        }
        return pluginManifestList;
    }

    private static PluginManifest toPluginManifest(PluginInfo metadata) {
        PluginManifest pluginManifest = new PluginManifest();
        pluginManifest.setKey(metadata.getKey());
        pluginManifest.setName(metadata.getName());
        Version version = metadata.getVersion();
        if (version != null) {
            pluginManifest.setVersion(version.getName());
        }
        pluginManifest.setDescription(metadata.getDescription());
        pluginManifest.setMainClass(metadata.getMainClass());
        pluginManifest.setOrganization(metadata.getOrganizationName());
        pluginManifest.setOrganizationUrl(metadata.getOrganizationUrl());
        pluginManifest.setLicense(metadata.getLicense());
        pluginManifest.setHomepage(metadata.getHomepageUrl());
        pluginManifest.setIssueTrackerUrl(metadata.getIssueTrackerUrl());
        pluginManifest.setBasePlugin(metadata.getBasePlugin());
        pluginManifest.setRequirePlugins(Collections2.transform((Collection)metadata.getRequiredPlugins(), (Function)RequiredPluginToString.INSTANCE).toArray(new String[metadata.getRequiredPlugins().size()]));
        return pluginManifest;
    }

    private static enum RequiredPluginToString implements Function<PluginInfo.RequiredPlugin, String>
    {
        INSTANCE;


        public String apply(@Nonnull PluginInfo.RequiredPlugin requiredPlugin) {
            return requiredPlugin.toString();
        }
    }
}

