/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.platform.ws.SystemInfoWriter;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.UserSession;

public class InfoAction
implements SystemWsAction {
    private final SystemInfoWriter systemInfoWriter;
    private final UserSession userSession;

    public InfoAction(UserSession userSession, SystemInfoWriter systemInfoWriter) {
        this.userSession = userSession;
        this.systemInfoWriter = systemInfoWriter;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("info").setDescription("Get detailed information about system configuration.<br/>Requires 'Administer' permissions.<br/>Since 5.5, this web service becomes internal in order to more easily update result.").setSince("5.1").setInternal(true).setResponseExample(this.getClass().getResource("/org/sonar/server/platform/ws/info-example.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        StringWriter stringWriter = new StringWriter();
        JsonWriter json = JsonWriter.of((Writer)stringWriter);
        json.beginObject();
        this.systemInfoWriter.write(json);
        json.endObject();
        response.stream().setMediaType("application/json");
        IOUtils.write((String)stringWriter.toString(), (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
    }
}

