/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.server.platform.ws.ChangeLogLevelService;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.UserSession;

public class ChangeLogLevelAction
implements SystemWsAction {
    private static final String PARAM_LEVEL = "level";
    private final UserSession userSession;
    private final ChangeLogLevelService service;

    public ChangeLogLevelAction(UserSession userSession, ChangeLogLevelService service) {
        this.userSession = userSession;
        this.service = service;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction newAction = controller.createAction("change_log_level").setDescription("Temporarily changes level of logs. New level is not persistent and is lost when restarting server. Requires system administration permission.").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        newAction.createParam(PARAM_LEVEL).setDescription("The new level. Be cautious: DEBUG, and even more TRACE, may have performance impacts.").setPossibleValues(LogbackHelper.allowedLogLevels()).setRequired(true);
    }

    public void handle(Request wsRequest, Response wsResponse) throws InterruptedException {
        this.userSession.checkIsSystemAdministrator();
        LoggerLevel level = LoggerLevel.valueOf((String)wsRequest.mandatoryParam(PARAM_LEVEL));
        this.service.changeLogLevel(level);
        wsResponse.noContent();
    }
}

