/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class DbSection
implements SystemInfoSection,
Global {
    private final DbClient dbClient;

    public DbSection(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Database");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            DatabaseMetaData metadata = dbSession.getConnection().getMetaData();
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Database", (String)metadata.getDatabaseProductName());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Database Version", (String)metadata.getDatabaseProductVersion());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Username", (String)metadata.getUserName());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"URL", (String)metadata.getURL());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Driver", (String)metadata.getDriverName());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Driver Version", (String)metadata.getDriverVersion());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to get DB metadata", e);
        }
        return protobuf.build();
    }
}

