/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import org.apache.commons.dbcp.BasicDataSource;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.db.DbClient;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;
import org.sonar.server.platform.monitoring.BaseSectionMBean;
import org.sonar.server.platform.monitoring.DbConnectionSectionMBean;

public class DbConnectionSection
extends BaseSectionMBean
implements DbConnectionSectionMBean {
    private final DatabaseVersion dbVersion;
    private final DbClient dbClient;
    private final SonarRuntime runtime;

    public DbConnectionSection(DatabaseVersion dbVersion, DbClient dbClient, SonarRuntime runtime) {
        this.dbVersion = dbVersion;
        this.dbClient = dbClient;
        this.runtime = runtime;
    }

    @Override
    public String name() {
        return "Database";
    }

    @Override
    public String getMigrationStatus() {
        return this.dbVersion.getStatus().name();
    }

    @Override
    public int getPoolActiveConnections() {
        return this.commonsDbcp().getNumActive();
    }

    @Override
    public int getPoolMaxActiveConnections() {
        return this.commonsDbcp().getMaxActive();
    }

    @Override
    public int getPoolIdleConnections() {
        return this.commonsDbcp().getNumIdle();
    }

    @Override
    public int getPoolMaxIdleConnections() {
        return this.commonsDbcp().getMaxIdle();
    }

    @Override
    public int getPoolMinIdleConnections() {
        return this.commonsDbcp().getMinIdle();
    }

    @Override
    public int getPoolInitialSize() {
        return this.commonsDbcp().getInitialSize();
    }

    @Override
    public long getPoolMaxWaitMillis() {
        return this.commonsDbcp().getMaxWait();
    }

    @Override
    public boolean getPoolRemoveAbandoned() {
        return this.commonsDbcp().getRemoveAbandoned();
    }

    @Override
    public int getPoolRemoveAbandonedTimeoutSeconds() {
        return this.commonsDbcp().getRemoveAbandonedTimeout();
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        String side = this.runtime.getSonarQubeSide() == SonarQubeSide.COMPUTE_ENGINE ? "Compute Engine" : "Web";
        protobuf.setName(side + " Database Connection");
        this.completePoolAttributes(protobuf);
        return protobuf.build();
    }

    private void completePoolAttributes(ProtobufSystemInfo.Section.Builder protobuf) {
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Active Connections", (long)this.getPoolActiveConnections());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Max Connections", (long)this.getPoolMaxActiveConnections());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Initial Size", (long)this.getPoolInitialSize());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Idle Connections", (long)this.getPoolIdleConnections());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Min Idle Connections", (long)this.getPoolMinIdleConnections());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Max Idle Connections", (long)this.getPoolMaxIdleConnections());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Max Wait (ms)", (long)this.getPoolMaxWaitMillis());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Remove Abandoned", (Boolean)this.getPoolRemoveAbandoned());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Pool Remove Abandoned Timeout (seconds)", (long)this.getPoolRemoveAbandonedTimeoutSeconds());
    }

    private BasicDataSource commonsDbcp() {
        return (BasicDataSource)this.dbClient.getDatabase().getDataSource();
    }
}

