/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.server.platform.ServerFileSystem;

public class TempFolderProvider
extends ProviderAdapter {
    private TempFolder tempFolder;

    public TempFolder provide(ServerFileSystem fs) {
        if (this.tempFolder == null) {
            File tempDir = new File(fs.getTempDir(), "tmp");
            try {
                FileUtils.forceMkdir((File)tempDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create temp directory " + tempDir, e);
            }
            this.tempFolder = new DefaultTempFolder(tempDir);
        }
        return this.tempFolder;
    }
}

