/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import ch.qos.logback.classic.Level;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.picocontainer.Startable;
import org.slf4j.LoggerFactory;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.server.app.ServerProcessLogging;

@ServerSide
@ComputeEngineSide
public class ServerLogging
implements Startable {
    private static ServerLogging instance;
    private final LogbackHelper helper;
    private final Configuration config;
    private final ServerProcessLogging serverProcessLogging;
    private final Database database;

    public ServerLogging(Configuration config, ServerProcessLogging serverProcessLogging, Database database) {
        this(new LogbackHelper(), config, serverProcessLogging, database);
    }

    @VisibleForTesting
    ServerLogging(LogbackHelper helper, Configuration config, ServerProcessLogging serverProcessLogging, Database database) {
        this.helper = helper;
        this.config = config;
        this.serverProcessLogging = serverProcessLogging;
        this.database = database;
    }

    public void start() {
        instance = this;
    }

    public void stop() {
        instance = null;
    }

    public static void changeLevelFromHazelcastDistributedQuery(LoggerLevel level) {
        instance.changeLevel(level);
    }

    public void changeLevel(LoggerLevel level) {
        Level logbackLevel = Level.toLevel((String)level.name());
        this.database.enableSqlLogging(level == LoggerLevel.TRACE);
        this.helper.changeRoot(this.serverProcessLogging.getLogLevelConfig(), logbackLevel);
        LoggerFactory.getLogger(ServerLogging.class).info("Level of logs changed to {}", (Object)level);
    }

    public LoggerLevel getRootLoggerLevel() {
        return Loggers.get((String)"ROOT").getLevel();
    }

    public File getLogsDir() {
        return new File((String)this.config.get("sonar.path.logs").get());
    }
}

