/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.io.File;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.sonar.api.SonarRuntime;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ServerSide;
import org.sonar.server.platform.ServerFileSystem;
import org.sonar.server.platform.StartupMetadata;
import org.sonar.server.platform.UrlSettings;

@ComputeEngineSide
@ServerSide
public class ServerImpl
extends Server {
    private final Configuration config;
    private final StartupMetadata state;
    private final ServerFileSystem fs;
    private final UrlSettings urlSettings;
    private final SonarRuntime runtime;

    public ServerImpl(Configuration config, StartupMetadata state, ServerFileSystem fs, UrlSettings urlSettings, SonarRuntime runtime) {
        this.config = config;
        this.state = state;
        this.fs = fs;
        this.urlSettings = urlSettings;
        this.runtime = runtime;
    }

    @CheckForNull
    public String getId() {
        return this.config.get("sonar.core.id").orElse(null);
    }

    public String getPermanentServerId() {
        return this.getId();
    }

    public String getVersion() {
        return this.runtime.getApiVersion().toString();
    }

    public Date getStartedAt() {
        return new Date(this.state.getStartedAt());
    }

    public File getRootDir() {
        return this.fs.getHomeDir();
    }

    public String getContextPath() {
        return this.urlSettings.getContextPath();
    }

    public String getPublicRootUrl() {
        return this.urlSettings.getBaseUrl();
    }

    public boolean isDev() {
        return false;
    }

    public boolean isSecured() {
        return this.urlSettings.isSecured();
    }

    public String getURL() {
        return this.urlSettings.getBaseUrl();
    }
}

