/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonarqube.ws.client.permission.RemoveUserFromTemplateWsRequest;

public class RemoveUserFromTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;

    public RemoveUserFromTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    private static RemoveUserFromTemplateWsRequest toRemoveUserFromTemplateWsRequest(Request request) {
        return new RemoveUserFromTemplateWsRequest().setPermission(request.mandatoryParam("permission")).setLogin(request.mandatoryParam("login")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_user_from_template").setPost(true).setSince("5.2").setDescription("Remove a user from a permission template.<br /> Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createUserLoginParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(RemoveUserFromTemplateAction.toRemoveUserFromTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(RemoveUserFromTemplateWsRequest request) {
        String permission = request.getPermission();
        String userLogin = request.getLogin();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionRequestValidator.validateProjectPermission(permission);
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            UserId user = this.wsSupport.findUser(dbSession, userLogin);
            this.dbClient.permissionTemplateDao().deleteUserPermission(dbSession, template.getId(), Integer.valueOf(user.getId()), permission);
            dbSession.commit();
        }
    }
}

