/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.client.permission.DeleteTemplateWsRequest;

public class DeleteTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionWsSupport finder;
    private final DefaultTemplatesResolver defaultTemplatesResolver;

    public DeleteTemplateAction(DbClient dbClient, UserSession userSession, PermissionWsSupport support, DefaultTemplatesResolver defaultTemplatesResolver) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.finder = support;
        this.defaultTemplatesResolver = defaultTemplatesResolver;
    }

    private static DeleteTemplateWsRequest toDeleteTemplateWsRequest(Request request) {
        return new DeleteTemplateWsRequest().setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete_template").setDescription("Delete a permission template.<br />Requires the following permission: 'Administer System'.").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        this.doHandle(DeleteTemplateAction.toDeleteTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(DeleteTemplateWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.finder.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            DefaultTemplates defaultTemplates = this.retrieveDefaultTemplates(dbSession, template);
            this.checkTemplateUuidIsNotDefault(template, defaultTemplates);
            this.dbClient.permissionTemplateDao().deleteById(dbSession, template.getId().longValue());
            this.updateViewDefaultTemplateWhenGovernanceIsNotInstalled(dbSession, template, defaultTemplates);
            dbSession.commit();
        }
    }

    private void updateViewDefaultTemplateWhenGovernanceIsNotInstalled(DbSession dbSession, PermissionTemplateDto template, DefaultTemplates defaultTemplates) {
        String viewDefaultTemplateUuid = defaultTemplates.getViewUuid();
        if (viewDefaultTemplateUuid != null && viewDefaultTemplateUuid.equals(template.getUuid())) {
            defaultTemplates.setViewUuid(null);
            this.dbClient.organizationDao().setDefaultTemplates(dbSession, template.getOrganizationUuid(), defaultTemplates);
        }
    }

    private DefaultTemplates retrieveDefaultTemplates(DbSession dbSession, PermissionTemplateDto template) {
        return (DefaultTemplates)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().getDefaultTemplates(dbSession, template.getOrganizationUuid()), "Can't find default templates of Organization with uuid '%s' to which template with uuid '%s' belongs", template.getOrganizationUuid(), template.getUuid());
    }

    private void checkTemplateUuidIsNotDefault(PermissionTemplateDto template, DefaultTemplates defaultTemplates) {
        DefaultTemplatesResolver.ResolvedDefaultTemplates resolvedDefaultTemplates = this.defaultTemplatesResolver.resolve(defaultTemplates);
        WsUtils.checkRequest(!resolvedDefaultTemplates.getProject().equals(template.getUuid()), "It is not possible to delete the default permission template for projects", new Object[0]);
        resolvedDefaultTemplates.getView().ifPresent(viewDefaultTemplateUuid -> WsUtils.checkRequest(!viewDefaultTemplateUuid.equals(template.getUuid()), "It is not possible to delete the default permission template for views", new Object[0]));
    }
}

