/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.server.ws.WsUtils;

public class ProjectWsRef {
    private static final String MSG_ID_OR_KEY_MUST_BE_PROVIDED = "Project id or project key can be provided, not both.";
    private final String uuid;
    private final String key;

    private ProjectWsRef(@Nullable String uuid, @Nullable String key) {
        this.uuid = uuid;
        this.key = key;
        WsUtils.checkRequest(this.uuid != null ^ this.key != null, MSG_ID_OR_KEY_MUST_BE_PROVIDED, new Object[0]);
    }

    public static Optional<ProjectWsRef> newOptionalWsProjectRef(@Nullable String uuid, @Nullable String key) {
        if (uuid == null && key == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new ProjectWsRef(uuid, key));
    }

    public static ProjectWsRef newWsProjectRef(@Nullable String uuid, @Nullable String key) {
        return new ProjectWsRef(uuid, key);
    }

    @CheckForNull
    public String uuid() {
        return this.uuid;
    }

    @CheckForNull
    public String key() {
        return this.key;
    }
}

