/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.sonar.db.DbSession;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.permission.GroupPermissionChange;
import org.sonar.server.permission.GroupPermissionChanger;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.UserPermissionChange;
import org.sonar.server.permission.UserPermissionChanger;

public class PermissionUpdater {
    private final ProjectIndexers projectIndexers;
    private final UserPermissionChanger userPermissionChanger;
    private final GroupPermissionChanger groupPermissionChanger;

    public PermissionUpdater(ProjectIndexers projectIndexers, UserPermissionChanger userPermissionChanger, GroupPermissionChanger groupPermissionChanger) {
        this.projectIndexers = projectIndexers;
        this.userPermissionChanger = userPermissionChanger;
        this.groupPermissionChanger = groupPermissionChanger;
    }

    public void apply(DbSession dbSession, Collection<PermissionChange> changes) {
        ArrayList<String> projectOrViewUuids = new ArrayList<String>();
        for (PermissionChange change : changes) {
            boolean changed = this.doApply(dbSession, change);
            Optional<ProjectId> projectId = change.getProjectId();
            if (!changed || !projectId.isPresent()) continue;
            projectOrViewUuids.add(projectId.get().getUuid());
        }
        this.projectIndexers.commitAndIndexByProjectUuids(dbSession, projectOrViewUuids, ProjectIndexer.Cause.PERMISSION_CHANGE);
    }

    private boolean doApply(DbSession dbSession, PermissionChange change) {
        if (change instanceof UserPermissionChange) {
            return this.userPermissionChanger.apply(dbSession, (UserPermissionChange)change);
        }
        if (change instanceof GroupPermissionChange) {
            return this.groupPermissionChanger.apply(dbSession, (GroupPermissionChange)change);
        }
        throw new UnsupportedOperationException("Unsupported permission change: " + change.getClass());
    }
}

