/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Organizations;

public class UpdateAction
implements OrganizationsWsAction {
    private static final String ACTION = "update";
    private final UserSession userSession;
    private final OrganizationsWsSupport wsSupport;
    private final DbClient dbClient;
    private final OrganizationFlags organizationFlags;

    public UpdateAction(UserSession userSession, OrganizationsWsSupport wsSupport, DbClient dbClient, OrganizationFlags organizationFlags) {
        this.userSession = userSession;
        this.wsSupport = wsSupport;
        this.dbClient = dbClient;
        this.organizationFlags = organizationFlags;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Update an organization.<br/>Require 'Administer System' permission. Organization support must be enabled.").setInternal(true).setSince("6.2").setHandler((RequestHandler)this);
        action.createParam("key").setRequired(true).setDescription("Organization key").setExampleValue((Object)"foo-company");
        this.wsSupport.addOrganizationDetailsParams(action, false);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.organizationFlags.checkEnabled(dbSession);
            String key = request.mandatoryParam("key");
            UpdateOrganizationRequest updateRequest = new UpdateOrganizationRequest(request.getParam("name", (rqt, paramKey) -> this.wsSupport.getAndCheckName((Request)rqt)), request.getParam("description", (rqt, paramKey) -> UpdateAction.emptyAsNull(this.wsSupport.getAndCheckDescription((Request)rqt))), request.getParam("url", (rqt, paramKey) -> UpdateAction.emptyAsNull(this.wsSupport.getAndCheckUrl((Request)rqt))), request.getParam("avatar", (rqt, paramKey) -> UpdateAction.emptyAsNull(this.wsSupport.getAndCheckAvatar((Request)rqt))));
            OrganizationDto dto = this.getDto(dbSession, key);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, dto);
            dto.setName((String)updateRequest.getName().or(() -> ((OrganizationDto)dto).getName())).setDescription((String)updateRequest.getDescription().or(() -> ((OrganizationDto)dto).getDescription())).setUrl((String)updateRequest.getUrl().or(() -> ((OrganizationDto)dto).getUrl())).setAvatarUrl((String)updateRequest.getAvatar().or(() -> ((OrganizationDto)dto).getAvatarUrl()));
            this.dbClient.organizationDao().update(dbSession, dto);
            dbSession.commit();
            this.writeResponse(request, response, dto);
        }
    }

    @CheckForNull
    private static String emptyAsNull(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private OrganizationDto getDto(DbSession dbSession, String key) {
        Optional organizationDto = this.dbClient.organizationDao().selectByKey(dbSession, key);
        if (!organizationDto.isPresent()) {
            throw new NotFoundException(String.format("Organization not found for key '%s'", key));
        }
        return (OrganizationDto)organizationDto.get();
    }

    private void writeResponse(Request request, Response response, OrganizationDto dto) {
        WsUtils.writeProtobuf((Message)Organizations.UpdateWsResponse.newBuilder().setOrganization(this.wsSupport.toOrganization(dto)).build(), request, response);
    }

    private static final class UpdateOrganizationRequest {
        private final Request.Param<String> name;
        private final Request.Param<String> description;
        private final Request.Param<String> url;
        private final Request.Param<String> avatar;

        private UpdateOrganizationRequest(Request.Param<String> name, Request.Param<String> description, Request.Param<String> url, Request.Param<String> avatar) {
            this.name = name;
            this.description = description;
            this.url = url;
            this.avatar = avatar;
        }

        public Request.Param<String> getName() {
            return this.name;
        }

        public Request.Param<String> getDescription() {
            return this.description;
        }

        public Request.Param<String> getUrl() {
            return this.url;
        }

        public Request.Param<String> getAvatar() {
            return this.avatar;
        }
    }
}

