/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.OrganizationCreation;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.OrganizationValidation;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Organizations;

public class CreateAction
implements OrganizationsWsAction {
    private static final String ACTION = "create";
    private final Configuration config;
    private final UserSession userSession;
    private final DbClient dbClient;
    private final OrganizationsWsSupport wsSupport;
    private final OrganizationValidation organizationValidation;
    private final OrganizationCreation organizationCreation;
    private final OrganizationFlags organizationFlags;

    public CreateAction(Configuration config, UserSession userSession, DbClient dbClient, OrganizationsWsSupport wsSupport, OrganizationValidation organizationValidation, OrganizationCreation organizationCreation, OrganizationFlags organizationFlags) {
        this.config = config;
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.organizationValidation = organizationValidation;
        this.organizationCreation = organizationCreation;
        this.organizationFlags = organizationFlags;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Create an organization.<br />Requires 'Administer System' permission unless any logged in user is allowed to create an organization (see appropriate setting). Organization support must be enabled.").setResponseExample(this.getClass().getResource("create-example.json")).setInternal(true).setSince("6.2").setHandler((RequestHandler)this);
        action.createParam("key").setRequired(false).setDescription("Key of the organization. <br />The key is unique to the whole SonarQube. <br/>When not specified, the key is computed from the name. <br />Otherwise, it must be between 2 and 32 chars long. All chars must be lower-case letters (a to z), digits or dash (but dash can neither be trailing nor heading)").setExampleValue((Object)"foo-company");
        this.wsSupport.addOrganizationDetailsParams(action, true);
    }

    public void handle(Request request, Response response) throws Exception {
        if (this.config.getBoolean("sonar.organizations.anyoneCanCreate").orElse(false).booleanValue()) {
            this.userSession.checkLoggedIn();
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
        String name = this.wsSupport.getAndCheckMandatoryName(request);
        String requestKey = this.getAndCheckKey(request);
        String key = this.useOrGenerateKey(requestKey, name);
        String description = this.wsSupport.getAndCheckDescription(request);
        String url = this.wsSupport.getAndCheckUrl(request);
        String avatar = this.wsSupport.getAndCheckAvatar(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.organizationFlags.checkEnabled(dbSession);
            UserDto currentUser = this.dbClient.userDao().selectActiveUserByLogin(dbSession, this.userSession.getLogin());
            OrganizationDto organization = this.organizationCreation.create(dbSession, currentUser, OrganizationCreation.NewOrganization.newOrganizationBuilder().setName(name).setKey(key).setDescription(description).setUrl(url).setAvatarUrl(avatar).build());
            this.writeResponse(request, response, organization);
        }
        catch (OrganizationCreation.KeyConflictException e) {
            Preconditions.checkArgument((requestKey == null ? 1 : 0) != 0, (String)"Key '%s' is already used. Specify another one.", (Object[])new Object[]{key});
            Preconditions.checkArgument((requestKey != null ? 1 : 0) != 0, (String)"Key '%s' generated from name '%s' is already used. Specify one.", (Object[])new Object[]{key, name});
        }
    }

    @CheckForNull
    private String getAndCheckKey(Request request) {
        String rqstKey = request.param("key");
        if (rqstKey != null) {
            return this.organizationValidation.checkKey(rqstKey);
        }
        return rqstKey;
    }

    private String useOrGenerateKey(@Nullable String key, String name) {
        if (key == null) {
            return this.organizationValidation.generateKeyFrom(name);
        }
        return key;
    }

    private void writeResponse(Request request, Response response, OrganizationDto dto) {
        WsUtils.writeProtobuf((Message)Organizations.CreateWsResponse.newBuilder().setOrganization(this.wsSupport.toOrganization(dto)).build(), request, response);
    }
}

