/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.metric.ws.MetricsWsAction;
import org.sonar.server.user.UserSession;

public class DeleteAction
implements MetricsWsAction {
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_KEYS = "keys";
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setHandler((RequestHandler)this).setSince("5.2").setPost(true).setDescription("Delete metrics and associated measures. Delete only custom metrics.<br />Ids or keys must be provided. <br />Requires 'Administer System' permission.");
        action.createParam(PARAM_IDS).setDescription("Metrics ids to delete.").setExampleValue((Object)"5, 23, 42");
        action.createParam(PARAM_KEYS).setDescription("Metrics keys to delete").setExampleValue((Object)"team_size, business_value");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<Integer> ids = this.loadIds(dbSession, request);
            this.dbClient.metricDao().disableCustomByIds(dbSession, ids);
            this.dbClient.customMeasureDao().deleteByMetricIds(dbSession, ids);
            this.dbClient.gateConditionDao().deleteConditionsWithInvalidMetrics(dbSession);
            dbSession.commit();
        }
        response.noContent();
    }

    private List<Integer> loadIds(DbSession dbSession, Request request) {
        List idsAsStrings = request.paramAsStrings(PARAM_IDS);
        List keys = request.paramAsStrings(PARAM_KEYS);
        Preconditions.checkArgument((idsAsStrings != null || keys != null ? 1 : 0) != 0, (Object)"Ids or keys must be provided.");
        List ids = idsAsStrings != null ? Lists.transform((List)idsAsStrings, Integer::valueOf) : Lists.transform((List)this.dbClient.metricDao().selectByKeys(dbSession, keys), MetricDto::getId);
        return ids;
    }
}

