/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.component.SnapshotDto;
import org.sonarqube.ws.WsMeasures;

class SnapshotDtoToWsPeriods {
    private SnapshotDtoToWsPeriods() {
    }

    static List<WsMeasures.Period> snapshotToWsPeriods(@Nullable SnapshotDto snapshot) {
        if (snapshot == null) {
            return Collections.emptyList();
        }
        ArrayList<WsMeasures.Period> periods = new ArrayList<WsMeasures.Period>();
        if (snapshot.getPeriodDate() != null) {
            periods.add(SnapshotDtoToWsPeriods.snapshotDtoToWsPeriod(snapshot));
        }
        return periods;
    }

    private static WsMeasures.Period snapshotDtoToWsPeriod(SnapshotDto snapshot) {
        Long periodDate;
        String periodModeParameter;
        WsMeasures.Period.Builder period = WsMeasures.Period.newBuilder();
        period.setIndex(1);
        String periodMode = snapshot.getPeriodMode();
        if (periodMode != null) {
            period.setMode(periodMode);
        }
        if ((periodModeParameter = snapshot.getPeriodModeParameter()) != null) {
            period.setParameter(periodModeParameter);
        }
        if ((periodDate = snapshot.getPeriodDate()) != null) {
            period.setDate(DateUtils.formatDateTime((long)periodDate));
        }
        return period.build();
    }
}

