/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import javax.annotation.Nullable;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonarqube.ws.WsMeasures;

class MeasureDtoToWsMeasure {
    private MeasureDtoToWsMeasure() {
    }

    static void updateMeasureBuilder(WsMeasures.Measure.Builder measureBuilder, MetricDto metricDto, MeasureDto measureDto) {
        Double value = measureDto.getValue();
        Double variation = measureDto.getVariation();
        MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, metricDto, value == null ? Double.NaN : value, measureDto.getData(), variation == null ? Double.NaN : variation);
    }

    static void updateMeasureBuilder(WsMeasures.Measure.Builder measureBuilder, MetricDto metric, double doubleValue, @Nullable String stringValue, double variation) {
        measureBuilder.setMetric(metric.getKey());
        if (!Double.isNaN(doubleValue) || stringValue != null) {
            measureBuilder.setValue(MeasureValueFormatter.formatMeasureValue(doubleValue, stringValue, metric));
        }
        WsMeasures.PeriodValue.Builder periodBuilder = WsMeasures.PeriodValue.newBuilder();
        if (Double.isNaN(variation)) {
            return;
        }
        measureBuilder.getPeriodsBuilder().addPeriodsValue(periodBuilder.clear().setIndex(1).setValue(MeasureValueFormatter.formatNumericalValue(variation, metric)));
    }
}

