/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.server.es.DefaultIndexSettingsElement;

class ProjectsTextSearchQueryFactory {
    private ProjectsTextSearchQueryFactory() {
    }

    static QueryBuilder createQuery(String queryText) {
        BoolQueryBuilder featureQuery = QueryBuilders.boolQuery();
        Arrays.stream(ComponentTextSearchFeature.values()).map(f -> f.getQuery(queryText)).forEach(arg_0 -> ((BoolQueryBuilder)featureQuery).should(arg_0));
        return featureQuery;
    }

    private static enum ComponentTextSearchFeature {
        EXACT_IGNORE_CASE{

            @Override
            QueryBuilder getQuery(String queryText) {
                return QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), (Object)queryText).boost(2.5f);
            }
        }
        ,
        PREFIX{

            @Override
            QueryBuilder getQuery(String queryText) {
                return this.prefixAndPartialQuery(queryText, "name", "name").boost(2.0f);
            }
        }
        ,
        PREFIX_IGNORE_CASE{

            @Override
            QueryBuilder getQuery(String queryText) {
                String lowerCaseQueryText = queryText.toLowerCase(Locale.ENGLISH);
                return this.prefixAndPartialQuery(lowerCaseQueryText, DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), "name").boost(3.0f);
            }
        }
        ,
        PARTIAL{

            @Override
            QueryBuilder getQuery(String queryText) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                this.split(queryText).map(text -> this.partialTermQuery((String)text, "name")).forEach(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
                return queryBuilder.boost(0.5f);
            }
        }
        ,
        KEY{

            @Override
            QueryBuilder getQuery(String queryText) {
                return QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("key"), (Object)queryText).boost(50.0f);
            }
        };


        abstract QueryBuilder getQuery(String var1);

        protected Stream<String> split(String queryText) {
            return Arrays.stream(queryText.split("[\\s]+")).filter(StringUtils::isNotEmpty);
        }

        protected BoolQueryBuilder prefixAndPartialQuery(String queryText, String fieldName, String originalFieldName) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            AtomicBoolean first = new AtomicBoolean(true);
            this.split(queryText).map(queryTerm -> {
                if (first.getAndSet(false)) {
                    return QueryBuilders.prefixQuery((String)fieldName, (String)queryTerm);
                }
                return this.partialTermQuery((String)queryTerm, originalFieldName);
            }).forEach(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
            return queryBuilder;
        }

        protected MatchQueryBuilder partialTermQuery(String queryTerm, String fieldName) {
            String truncatedQuery = StringUtils.left((String)queryTerm, (int)15);
            return QueryBuilders.matchQuery((String)DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER.subField(fieldName), (Object)truncatedQuery);
        }
    }
}

