/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;

public class NewIssuesNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "NewIssues";
    private final NotificationManager manager;

    public NewIssuesNotificationDispatcher(NotificationManager manager) {
        super("new-issues");
        this.manager = manager;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return NotificationDispatcherMetadata.create(KEY).setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    }

    @Override
    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        String projectKey = notification.getFieldValue("projectKey");
        Multimap<String, NotificationChannel> subscribedRecipients = this.manager.findSubscribedRecipientsForDispatcher(this, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
        for (Map.Entry channelsByRecipients : subscribedRecipients.asMap().entrySet()) {
            String userLogin = (String)channelsByRecipients.getKey();
            for (NotificationChannel channel : (Collection)channelsByRecipients.getValue()) {
                context.addUser(userLogin, channel);
            }
        }
    }
}

