/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.issue.notification.DistributedMetricStatsInt;
import org.sonar.server.issue.notification.MetricStatsInt;
import org.sonar.server.issue.notification.NewIssuesStatistics;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndex;

public class NewIssuesNotification
extends Notification {
    public static final String TYPE = "new-issues";
    private static final long serialVersionUID = -6305871981920103093L;
    private static final String COUNT = ".count";
    private static final String LABEL = ".label";
    private static final String DOT = ".";
    private final transient UserIndex userIndex;
    private final transient DbClient dbClient;
    private final transient Durations durations;

    NewIssuesNotification(UserIndex userIndex, DbClient dbClient, Durations durations) {
        this(TYPE, userIndex, dbClient, durations);
    }

    protected NewIssuesNotification(String type, UserIndex userIndex, DbClient dbClient, Durations durations) {
        super(type);
        this.userIndex = userIndex;
        this.dbClient = dbClient;
        this.durations = durations;
    }

    public NewIssuesNotification setAnalysisDate(Date d) {
        this.setFieldValue("projectDate", DateUtils.formatDateTime((Date)d));
        return this;
    }

    public NewIssuesNotification setProject(String projectKey, String projectName, @Nullable String branchName) {
        this.setFieldValue("projectName", projectName);
        this.setFieldValue("projectKey", projectKey);
        if (branchName != null) {
            this.setFieldValue("branch", branchName);
        }
        return this;
    }

    public NewIssuesNotification setProjectVersion(@Nullable String version) {
        if (version != null) {
            this.setFieldValue("projectVersion", version);
        }
        return this;
    }

    public NewIssuesNotification setStatistics(String projectName, NewIssuesStatistics.Stats stats) {
        this.setDefaultMessage(stats.getDistributedMetricStats(NewIssuesStatistics.Metric.RULE_TYPE).getOnLeak() + " new issues on " + projectName + ".\n");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.setRuleTypeStatistics(stats);
            this.setAssigneesStatistics(stats);
            this.setTagsStatistics(stats);
            this.setComponentsStatistics(dbSession, stats);
            this.setRuleStatistics(dbSession, stats);
        }
        return this;
    }

    private void setRuleStatistics(DbSession dbSession, NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.RULE;
        List<Map.Entry<String, MetricStatsInt>> fiveBiggest = NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak);
        Set ruleKeys = (Set)fiveBiggest.stream().map(Map.Entry::getKey).map(RuleKey::parse).collect(MoreCollectors.toSet((int)fiveBiggest.size()));
        Map ruleByRuleKey = (Map)this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, (Collection)ruleKeys).stream().collect(MoreCollectors.uniqueIndex(s -> s.getKey().toString()));
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> ruleStats : fiveBiggest) {
            String ruleKey = ruleStats.getKey();
            RuleDefinitionDto rule = (RuleDefinitionDto)Optional.ofNullable(ruleByRuleKey.get(ruleKey)).orElseThrow(() -> new RowNotFoundException(String.format("Rule with key '%s' does not exist", ruleKey)));
            String name = rule.getName() + " (" + rule.getLanguage() + ")";
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, name);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(ruleStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private void setComponentsStatistics(DbSession dbSession, NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.COMPONENT;
        int i = 1;
        List<Map.Entry<String, MetricStatsInt>> fiveBiggest = NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak);
        Set componentUuids = (Set)fiveBiggest.stream().map(Map.Entry::getKey).collect(MoreCollectors.toSet((int)fiveBiggest.size()));
        Map componentDtosByUuid = (Map)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
        for (Map.Entry<String, MetricStatsInt> componentStats : fiveBiggest) {
            String uuid = componentStats.getKey();
            String componentName = Optional.ofNullable(componentDtosByUuid.get(uuid)).map(ComponentDto::name).orElseThrow(() -> new RowNotFoundException(String.format("Component with uuid '%s' not found", uuid)));
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, componentName);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(componentStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private void setTagsStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.TAG;
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> tagStats : NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak)) {
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(tagStats.getValue().getOnLeak()));
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, tagStats.getKey());
            ++i;
        }
    }

    private void setAssigneesStatistics(NewIssuesStatistics.Stats stats) {
        NewIssuesStatistics.Metric metric = NewIssuesStatistics.Metric.ASSIGNEE;
        int i = 1;
        for (Map.Entry<String, MetricStatsInt> assigneeStats : NewIssuesNotification.fiveBiggest(stats.getDistributedMetricStats(metric), MetricStatsInt::getOnLeak)) {
            String login = assigneeStats.getKey();
            UserDoc user = this.userIndex.getNullableByLogin(login);
            String name = user == null ? login : user.name();
            this.setFieldValue((Object)((Object)metric) + DOT + i + LABEL, name);
            this.setFieldValue((Object)((Object)metric) + DOT + i + COUNT, String.valueOf(assigneeStats.getValue().getOnLeak()));
            ++i;
        }
    }

    private static List<Map.Entry<String, MetricStatsInt>> fiveBiggest(DistributedMetricStatsInt distributedMetricStatsInt, ToIntFunction<MetricStatsInt> biggerCriteria) {
        Comparator<Map.Entry> comparator = Comparator.comparingInt(a -> biggerCriteria.applyAsInt((MetricStatsInt)a.getValue()));
        return (List)distributedMetricStatsInt.getForLabels().entrySet().stream().sorted(comparator.reversed()).limit(5L).collect(MoreCollectors.toList((int)5));
    }

    public NewIssuesNotification setDebt(Duration debt) {
        this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.EFFORT) + COUNT, this.durations.format(debt));
        return this;
    }

    private void setRuleTypeStatistics(NewIssuesStatistics.Stats stats) {
        DistributedMetricStatsInt distributedMetricStats = stats.getDistributedMetricStats(NewIssuesStatistics.Metric.RULE_TYPE);
        this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + COUNT, String.valueOf(distributedMetricStats.getOnLeak()));
        Arrays.stream(RuleType.values()).forEach(ruleType -> this.setFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + DOT + ruleType + COUNT, String.valueOf(distributedMetricStats.getForLabel(ruleType.name()).map(MetricStatsInt::getOnLeak).orElse(0))));
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

