/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.server.issue.notification.MetricStatsInt;

public class DistributedMetricStatsInt {
    private MetricStatsInt globalStats = new MetricStatsInt();
    private Map<String, MetricStatsInt> statsPerLabel = new HashMap<String, MetricStatsInt>();

    DistributedMetricStatsInt increment(String label, boolean onLeak) {
        this.globalStats.increment(onLeak);
        this.statsPerLabel.computeIfAbsent(label, l -> new MetricStatsInt()).increment(onLeak);
        return this;
    }

    Map<String, MetricStatsInt> getForLabels() {
        return Collections.unmodifiableMap(this.statsPerLabel);
    }

    public Optional<MetricStatsInt> getForLabel(String label) {
        return Optional.ofNullable(this.statsPerLabel.get(label));
    }

    public int getOnLeak() {
        return this.globalStats.getOnLeak();
    }

    public int getOffLeak() {
        return this.globalStats.getOffLeak();
    }

    public int getTotal() {
        return this.globalStats.getTotal();
    }

    public String toString() {
        return "DistributedMetricStatsInt{globalStats=" + this.globalStats + ", statsPerLabel=" + this.statsPerLabel + '}';
    }
}

