/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.sonar.core.util.stream.MoreCollectors;

public class IndexType {
    private static final String SEPARATOR = "/";
    private static final Splitter SEPARATOR_SPLITTER = Splitter.on((String)"/");
    private final String index;
    private final String type;
    private final String key;

    public IndexType(String index, String type) {
        this.index = Objects.requireNonNull(index);
        this.type = Objects.requireNonNull(type);
        this.key = index + SEPARATOR + type;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public static String[] getIndices(IndexType ... indexTypes) {
        return IndexType.getDetails(IndexType::getIndex, indexTypes);
    }

    public static String[] getTypes(IndexType ... indexTypes) {
        return IndexType.getDetails(IndexType::getType, indexTypes);
    }

    private static String[] getDetails(Function<? super IndexType, ? extends String> function, IndexType ... indexTypes) {
        return ((Set)Arrays.stream(indexTypes).map(function).collect(MoreCollectors.toSet((int)indexTypes.length))).toArray(new String[0]);
    }

    public String format() {
        return this.key;
    }

    public static IndexType parse(String s) {
        List split = SEPARATOR_SPLITTER.splitToList((CharSequence)s);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Unsupported IndexType value: " + s);
        }
        return new IndexType((String)split.get(0), (String)split.get(1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexType indexType = (IndexType)o;
        return this.key.equals(indexType.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "[" + this.index + SEPARATOR + this.type + "]";
    }
}

