/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.edition;

import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.edition.EditionManagementState;
import org.sonar.server.edition.MutableEditionManagementState;
import org.sonar.server.license.LicenseCommit;

public class FinalizeEditionChange
implements Startable {
    private static final Logger LOG = Loggers.get(FinalizeEditionChange.class);
    private final MutableEditionManagementState editionManagementState;
    @CheckForNull
    private final LicenseCommit licenseCommit;

    public FinalizeEditionChange(MutableEditionManagementState editionManagementState) {
        this(editionManagementState, null);
    }

    public FinalizeEditionChange(MutableEditionManagementState editionManagementState, @Nullable LicenseCommit licenseCommit) {
        this.editionManagementState = editionManagementState;
        this.licenseCommit = licenseCommit;
    }

    public void start() {
        EditionManagementState.PendingStatus status = this.editionManagementState.getPendingInstallationStatus();
        switch (status) {
            case NONE: {
                this.editionManagementState.clearInstallErrorMessage();
                return;
            }
            case MANUAL_IN_PROGRESS: 
            case AUTOMATIC_READY: {
                this.finalizeInstall();
                break;
            }
            case AUTOMATIC_IN_PROGRESS: {
                this.editionManagementState.installFailed("SonarQube was restarted before asynchronous installation of edition completed");
                break;
            }
            case UNINSTALL_IN_PROGRESS: {
                this.failIfLicenseCommitIsPresent();
                this.editionManagementState.finalizeInstallation(null);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported status " + (Object)((Object)status));
            }
        }
    }

    private void failIfLicenseCommitIsPresent() {
        if (this.licenseCommit != null) {
            throw new IllegalStateException("License Manager plugin is still present after uninstallation of the edition. Please remove it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeInstall() {
        String errorMessage = null;
        try {
            if (this.licenseCommit == null) {
                errorMessage = "Edition installation didn't complete. Some plugins were not installed.";
                LOG.warn(errorMessage);
                return;
            }
            Optional<String> newLicense = this.editionManagementState.getPendingLicense();
            if (!newLicense.isPresent()) {
                errorMessage = "Edition installation didn't complete. License was not found.";
                LOG.warn(errorMessage);
                return;
            }
            try {
                this.licenseCommit.update(newLicense.get());
            }
            catch (IllegalArgumentException e) {
                errorMessage = "Edition installation didn't complete. License is not valid. Please set a new license.";
                LOG.warn(errorMessage, (Throwable)e);
            }
        }
        finally {
            this.editionManagementState.finalizeInstallation(errorMessage);
        }
    }

    public void stop() {
        EditionManagementState.PendingStatus status = this.editionManagementState.getPendingInstallationStatus();
        if (status == EditionManagementState.PendingStatus.UNINSTALL_IN_PROGRESS) {
            if (this.licenseCommit != null) {
                LOG.debug("Removing license");
                this.licenseCommit.delete();
            } else {
                LOG.warn("License Manager plugin not found - cannot remove the license");
            }
        }
    }
}

