/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.step;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.computation.task.step.ComputationSteps;

public final class ComputationStepExecutor {
    private static final Logger LOGGER = Loggers.get(ComputationStepExecutor.class);
    private final ComputationSteps steps;
    @CheckForNull
    private final Listener listener;

    public ComputationStepExecutor(ComputationSteps steps) {
        this(steps, null);
    }

    public ComputationStepExecutor(ComputationSteps steps, @Nullable Listener listener) {
        this.steps = steps;
        this.listener = listener;
    }

    public void execute() {
        Profiler stepProfiler = Profiler.create((Logger)LOGGER);
        boolean allStepsExecuted = false;
        try {
            this.executeSteps(stepProfiler);
            allStepsExecuted = true;
        }
        finally {
            if (this.listener != null) {
                this.executeListener(allStepsExecuted);
            }
        }
    }

    private void executeSteps(Profiler stepProfiler) {
        for (ComputationStep step : this.steps.instances()) {
            stepProfiler.start();
            step.execute();
            stepProfiler.stopDebug(step.getDescription());
        }
    }

    private void executeListener(boolean allStepsExecuted) {
        try {
            this.listener.finished(allStepsExecuted);
        }
        catch (Throwable e) {
            LOGGER.error("Execution of listener failed", e);
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void finished(boolean var1);
    }
}

