/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.List;
import java.util.Map;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.VisitorsCrawler;
import org.sonar.server.computation.task.step.ComputationStep;

public class ExecuteVisitorsStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(ExecuteVisitorsStep.class);
    private final TreeRootHolder treeRootHolder;
    private final List<ComponentVisitor> visitors;

    public ExecuteVisitorsStep(TreeRootHolder treeRootHolder, List<ComponentVisitor> visitors) {
        this.treeRootHolder = treeRootHolder;
        this.visitors = visitors;
    }

    @Override
    public String getDescription() {
        return "Execute component visitors";
    }

    @Override
    public void execute() {
        VisitorsCrawler visitorsCrawler = new VisitorsCrawler(this.visitors, LOGGER.isDebugEnabled());
        visitorsCrawler.visit(this.treeRootHolder.getRoot());
        ExecuteVisitorsStep.logVisitorExecutionDurations(this.visitors, visitorsCrawler);
    }

    private static void logVisitorExecutionDurations(List<ComponentVisitor> visitors, VisitorsCrawler visitorsCrawler) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Execution time for each component visitor:");
            Map<ComponentVisitor, Long> cumulativeDurations = visitorsCrawler.getCumulativeDurations();
            for (ComponentVisitor visitor : visitors) {
                LOGGER.debug("  - {} | time={}ms", (Object)visitor.getClass().getSimpleName(), (Object)cumulativeDurations.get(visitor));
            }
        }
    }
}

