/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplication;
import org.sonar.server.computation.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.server.computation.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class DuplicationDataMeasuresStep
implements ComputationStep {
    private final MeasureRepository measureRepository;
    private final TreeRootHolder treeRootHolder;
    private final DuplicationRepository duplicationRepository;
    private final Metric duplicationDataMetric;

    public DuplicationDataMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, DuplicationRepository duplicationRepository) {
        this.measureRepository = measureRepository;
        this.treeRootHolder = treeRootHolder;
        this.duplicationRepository = duplicationRepository;
        this.duplicationDataMetric = metricRepository.getByKey("duplications_data");
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new DuplicationVisitor()).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute duplication data measures";
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private DuplicationVisitor() {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
        }

        @Override
        public void visitFile(Component file) {
            Iterable<Duplication> duplications = DuplicationDataMeasuresStep.this.duplicationRepository.getDuplications(file);
            if (!Iterables.isEmpty(duplications)) {
                this.computeDuplications(file, duplications);
            }
        }

        private void computeDuplications(Component component, Iterable<Duplication> duplications) {
            String duplicationXml = this.createXmlDuplications(component.getKey(), duplications);
            DuplicationDataMeasuresStep.this.measureRepository.add(component, DuplicationDataMeasuresStep.this.duplicationDataMetric, Measure.newMeasureBuilder().create(duplicationXml));
        }

        private String createXmlDuplications(String componentKey, Iterable<Duplication> duplications) {
            StringBuilder xml = new StringBuilder();
            xml.append("<duplications>");
            for (Duplication duplication : duplications) {
                xml.append("<g>");
                this.appendDuplication(xml, componentKey, duplication.getOriginal());
                for (Duplicate duplicate : duplication.getDuplicates()) {
                    this.processDuplicationBlock(xml, duplicate, componentKey);
                }
                xml.append("</g>");
            }
            xml.append("</duplications>");
            return xml.toString();
        }

        private void processDuplicationBlock(StringBuilder xml, Duplicate duplicate, String componentKey) {
            if (duplicate instanceof InnerDuplicate) {
                this.appendDuplication(xml, componentKey, duplicate);
            } else if (duplicate instanceof InProjectDuplicate) {
                this.appendDuplication(xml, ((InProjectDuplicate)duplicate).getFile().getKey(), duplicate);
            } else if (duplicate instanceof CrossProjectDuplicate) {
                String crossProjectComponentKey = ((CrossProjectDuplicate)duplicate).getFileKey();
                this.appendDuplication(xml, crossProjectComponentKey, duplicate);
            } else {
                throw new IllegalArgumentException("Unsupported type of Duplicate " + duplicate.getClass().getName());
            }
        }

        private void appendDuplication(StringBuilder xml, String componentKey, Duplicate duplicate) {
            this.appendDuplication(xml, componentKey, duplicate.getTextBlock());
        }

        private void appendDuplication(StringBuilder xml, String componentKey, TextBlock textBlock) {
            int length = textBlock.getEnd() - textBlock.getStart() + 1;
            xml.append("<b s=\"").append(textBlock.getStart()).append("\" l=\"").append(length).append("\" r=\"").append(StringEscapeUtils.escapeXml((String)componentKey)).append("\"/>");
        }
    }
}

