/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.sonar.core.util.CloseableIterator;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesRepository;

public class SourceLinesRepositoryImpl
implements SourceLinesRepository {
    private final BatchReportReader reportReader;

    public SourceLinesRepositoryImpl(BatchReportReader reportReader) {
        this.reportReader = reportReader;
    }

    @Override
    public CloseableIterator<String> readLines(Component file) {
        Objects.requireNonNull(file, "Component should not be bull");
        Preconditions.checkArgument((file.getType() == Component.Type.FILE ? 1 : 0) != 0, (String)"Component '%s' is not a file", (Object[])new Object[]{file});
        Optional<CloseableIterator<String>> linesIteratorOptional = this.reportReader.readFileSource(file.getReportAttributes().getRef());
        Preconditions.checkState((boolean)linesIteratorOptional.isPresent(), (String)"File '%s' has no source code", (Object[])new Object[]{file});
        CloseableIterator<String> lineIterator = linesIteratorOptional.get();
        return new ComponentLinesCloseableIterator(file, lineIterator, file.getFileAttributes().getLines());
    }

    private static class ComponentLinesCloseableIterator
    extends CloseableIterator<String> {
        private static final String EXTRA_END_LINE = "";
        private final Component file;
        private final CloseableIterator<String> delegate;
        private final int numberOfLines;
        private int currentLine = 0;

        private ComponentLinesCloseableIterator(Component file, CloseableIterator<String> lineIterator, int numberOfLines) {
            this.file = file;
            this.delegate = lineIterator;
            this.numberOfLines = numberOfLines;
        }

        public boolean hasNext() {
            if (this.delegate.hasNext()) {
                Preconditions.checkState((this.currentLine < this.numberOfLines ? 1 : 0) != 0, (String)"Source of file '%s' has at least one more line than the expected number (%s)", (Object[])new Object[]{this.file, this.numberOfLines});
                return true;
            }
            Preconditions.checkState((this.currentLine + 1 >= this.numberOfLines ? 1 : 0) != 0, (String)"Source of file '%s' has less lines (%s) than the expected number (%s)", (Object[])new Object[]{this.file, this.currentLine, this.numberOfLines});
            return this.currentLine < this.numberOfLines;
        }

        public String next() {
            if (!this.hasNext()) {
                return (String)this.delegate.next();
            }
            ++this.currentLine;
            if (this.delegate.hasNext()) {
                return (String)this.delegate.next();
            }
            return EXTRA_END_LINE;
        }

        protected String doNext() {
            throw new UnsupportedOperationException("No implemented because hasNext and next are override");
        }

        protected void doClose() throws Exception {
            this.delegate.close();
        }
    }
}

