/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplication;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;
import org.sonar.server.computation.task.projectanalysis.source.LineReader;

public class DuplicationLineReader
implements LineReader {
    private final Map<TextBlock, Integer> duplicatedTextBlockIndexByTextBlock;

    public DuplicationLineReader(Iterable<Duplication> duplications) {
        this.duplicatedTextBlockIndexByTextBlock = DuplicationLineReader.createIndexOfDuplicatedTextBlocks(duplications);
    }

    @Override
    public void read(DbFileSources.Line.Builder lineBuilder) {
        TextBlockContainsLine containsLine = new TextBlockContainsLine(lineBuilder.getLine());
        for (Integer textBlockIndex : FluentIterable.from(this.duplicatedTextBlockIndexByTextBlock.entrySet()).filter((Predicate)containsLine).transform((Function)MapEntryToBlockId.INSTANCE).toSortedList((Comparator)Ordering.natural())) {
            lineBuilder.addDuplication(textBlockIndex.intValue());
        }
    }

    private static Map<TextBlock, Integer> createIndexOfDuplicatedTextBlocks(Iterable<Duplication> duplications) {
        List<TextBlock> duplicatedTextBlocks = DuplicationLineReader.extractAllDuplicatedTextBlocks(duplications);
        Collections.sort(duplicatedTextBlocks);
        return FluentIterable.from(duplicatedTextBlocks).toMap((Function)new TextBlockIndexGenerator());
    }

    private static List<TextBlock> extractAllDuplicatedTextBlocks(Iterable<Duplication> duplications) {
        ArrayList<TextBlock> duplicatedBlock = new ArrayList<TextBlock>(Iterables.size(duplications));
        for (Duplication duplication : duplications) {
            duplicatedBlock.add(duplication.getOriginal());
            for (InnerDuplicate duplicate : FluentIterable.from(duplication.getDuplicates()).filter(InnerDuplicate.class)) {
                duplicatedBlock.add(duplicate.getTextBlock());
            }
        }
        return duplicatedBlock;
    }

    private static class TextBlockIndexGenerator
    implements Function<TextBlock, Integer> {
        int i = 1;

        private TextBlockIndexGenerator() {
        }

        @Nullable
        public Integer apply(TextBlock input) {
            return this.i++;
        }
    }

    private static enum MapEntryToBlockId implements Function<Map.Entry<TextBlock, Integer>, Integer>
    {
        INSTANCE;


        @Nonnull
        public Integer apply(@Nonnull Map.Entry<TextBlock, Integer> input) {
            return input.getValue();
        }
    }

    private static class TextBlockContainsLine
    implements Predicate<Map.Entry<TextBlock, Integer>> {
        private final int line;

        public TextBlockContainsLine(int line) {
            this.line = line;
        }

        public boolean apply(@Nonnull Map.Entry<TextBlock, Integer> input) {
            return TextBlockContainsLine.isLineInBlock(input.getKey(), this.line);
        }

        private static boolean isLineInBlock(TextBlock range, int line) {
            return line >= range.getStart() && line <= range.getEnd();
        }
    }
}

