/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import java.util.Optional;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.MergeBranchComponentUuids;
import org.sonar.server.computation.task.projectanalysis.scm.DbScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepositoryImpl;
import org.sonar.server.computation.task.projectanalysis.source.SourceHashRepository;

public class ScmInfoDbLoader {
    private static final Logger LOGGER = Loggers.get(ScmInfoDbLoader.class);
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private final SourceHashRepository sourceHashRepository;
    private final MergeBranchComponentUuids mergeBranchComponentUuid;

    public ScmInfoDbLoader(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient, SourceHashRepository sourceHashRepository, MergeBranchComponentUuids mergeBranchComponentUuid) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
        this.sourceHashRepository = sourceHashRepository;
        this.mergeBranchComponentUuid = mergeBranchComponentUuid;
    }

    public ScmInfo getScmInfoFromDb(Component file) {
        Optional<String> uuid = this.getFileUUid(file);
        if (!uuid.isPresent()) {
            return ScmInfoRepositoryImpl.NoScmInfo.INSTANCE;
        }
        LOGGER.trace("Reading SCM info from db for file '{}'", (Object)uuid.get());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            FileSourceDto dto = this.dbClient.fileSourceDao().selectSourceByFileUuid(dbSession, uuid.get());
            if (dto == null || !this.isDtoValid(file, dto)) {
                ScmInfoRepositoryImpl.NoScmInfo noScmInfo = ScmInfoRepositoryImpl.NoScmInfo.INSTANCE;
                return noScmInfo;
            }
            ScmInfo scmInfo = (ScmInfo)DbScmInfo.create(file, dto.getSourceData().getLinesList()).or((Object)ScmInfoRepositoryImpl.NoScmInfo.INSTANCE);
            return scmInfo;
        }
    }

    private Optional<String> getFileUUid(Component file) {
        if (!this.analysisMetadataHolder.isFirstAnalysis()) {
            return Optional.of(file.getUuid());
        }
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (branch.getMergeBranchUuid().isPresent()) {
            return Optional.ofNullable(this.mergeBranchComponentUuid.getUuid(file.getKey()));
        }
        return Optional.empty();
    }

    private boolean isDtoValid(Component file, FileSourceDto dto) {
        if (file.getStatus() == Component.Status.SAME) {
            return true;
        }
        return this.sourceHashRepository.getRawSourceHash(file).equals(dto.getSrcHash());
    }
}

