/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Changeset {
    private final String revision;
    private final long date;
    @CheckForNull
    private final String author;

    private Changeset(Builder builder) {
        this.revision = builder.revision.intern();
        this.author = builder.author == null ? null : builder.author.intern();
        this.date = builder.date;
    }

    public static Builder newChangesetBuilder() {
        return new Builder();
    }

    public String getRevision() {
        return this.revision;
    }

    public long getDate() {
        return this.date;
    }

    @CheckForNull
    public String getAuthor() {
        return this.author;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)o;
        return this.revision.equals(changeset.revision);
    }

    public int hashCode() {
        return Objects.hash(this.revision);
    }

    public String toString() {
        return "Changeset{revision='" + this.revision + '\'' + ", author='" + this.author + '\'' + ", date=" + this.date + '}';
    }

    public static class Builder {
        private String revision;
        private Long date;
        @CheckForNull
        private String author;

        private Builder() {
        }

        public Builder setRevision(String revision) {
            this.revision = Builder.checkRevision(revision);
            return this;
        }

        public Builder setDate(Long date) {
            this.date = Builder.checkDate(date);
            return this;
        }

        public Builder setAuthor(@Nullable String author) {
            this.author = author;
            return this;
        }

        public Changeset build() {
            Builder.checkRevision(this.revision);
            Builder.checkDate(this.date);
            return new Changeset(this);
        }

        private static String checkRevision(String revision) {
            return Objects.requireNonNull(revision, "Revision cannot be null");
        }

        private static long checkDate(Long date) {
            return Objects.requireNonNull(date, "Date cannot be null");
        }
    }
}

