/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue.commonrule;

import com.google.common.base.Optional;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.server.computation.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public abstract class AbstractCoverageRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric coverageMetric;
    private final Metric uncoveredMetric;
    private final Metric toCoverMetric;
    private final String minPropertyKey;

    public AbstractCoverageRule(ActiveRulesHolder activeRulesHolder, String ruleKey, String minPropertyKey, MeasureRepository measureRepository, Metric coverageMetric, Metric uncoveredMetric, Metric toCoverMetric) {
        super(activeRulesHolder, ruleKey);
        this.minPropertyKey = minPropertyKey;
        this.measureRepository = measureRepository;
        this.coverageMetric = coverageMetric;
        this.uncoveredMetric = uncoveredMetric;
        this.toCoverMetric = toCoverMetric;
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        double minimumCoverage;
        double coverage;
        Optional<Measure> coverageMeasure = this.measureRepository.getRawMeasure(file, this.coverageMetric);
        if (!file.getFileAttributes().isUnitTest() && coverageMeasure.isPresent() && (coverage = ((Measure)coverageMeasure.get()).getDoubleValue()) < (minimumCoverage = AbstractCoverageRule.getMinDensityParam(activeRule, this.minPropertyKey))) {
            return this.generateIssue(file, minimumCoverage);
        }
        return null;
    }

    private CommonRule.CommonRuleIssue generateIssue(Component file, double minimumCoverage) {
        Optional<Measure> uncoveredMeasure = this.measureRepository.getRawMeasure(file, this.uncoveredMetric);
        Optional<Measure> toCoverMeasure = this.measureRepository.getRawMeasure(file, this.toCoverMetric);
        double uncovered = uncoveredMeasure.isPresent() ? (double)((Measure)uncoveredMeasure.get()).getIntValue() : 0.0;
        double toCover = toCoverMeasure.isPresent() ? (double)((Measure)toCoverMeasure.get()).getIntValue() : 0.0;
        int effortToFix = (int)Math.ceil(toCover * minimumCoverage / 100.0 - (toCover - uncovered));
        return new CommonRule.CommonRuleIssue(effortToFix, this.formatMessage(effortToFix, minimumCoverage));
    }

    protected abstract String formatMessage(int var1, double var2);
}

