/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueMapper;

public class UpdateConflictResolver {
    private static final Logger LOG = Loggers.get(UpdateConflictResolver.class);

    public void resolve(DefaultIssue issue, IssueMapper mapper) {
        LOG.debug("Resolve conflict on issue {}", (Object)issue.key());
        IssueDto dbIssue = mapper.selectByKey(issue.key());
        if (dbIssue != null) {
            this.mergeFields(dbIssue, issue);
            mapper.update(IssueDto.toDtoForUpdate((DefaultIssue)issue, (long)System.currentTimeMillis()));
        }
    }

    @VisibleForTesting
    void mergeFields(IssueDto dbIssue, DefaultIssue issue) {
        this.resolveAssignee(dbIssue, issue);
        this.resolveSeverity(dbIssue, issue);
        this.resolveEffortToFix(dbIssue, issue);
        this.resolveResolution(dbIssue, issue);
        this.resolveStatus(dbIssue, issue);
    }

    private void resolveStatus(IssueDto dbIssue, DefaultIssue issue) {
        issue.setStatus(dbIssue.getStatus());
    }

    private void resolveResolution(IssueDto dbIssue, DefaultIssue issue) {
        issue.setResolution(dbIssue.getResolution());
    }

    private void resolveEffortToFix(IssueDto dbIssue, DefaultIssue issue) {
        issue.setGap(dbIssue.getGap());
    }

    private void resolveSeverity(IssueDto dbIssue, DefaultIssue issue) {
        if (dbIssue.isManualSeverity()) {
            issue.setManualSeverity(true);
            issue.setSeverity(dbIssue.getSeverity());
        }
    }

    private void resolveAssignee(IssueDto dbIssue, DefaultIssue issue) {
        issue.setAssignee(dbIssue.getAssignee());
    }
}

