/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Set;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;

public class BaseIssuesLoader {
    private final TreeRootHolder treeRootHolder;
    private final DbClient dbClient;

    public BaseIssuesLoader(TreeRootHolder treeRootHolder, DbClient dbClient) {
        this.treeRootHolder = treeRootHolder;
        this.dbClient = dbClient;
    }

    public Set<String> loadUuidsOfComponentsWithOpenIssues() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set set = this.dbClient.issueDao().selectComponentUuidsOfOpenIssuesForProjectUuid(dbSession, this.treeRootHolder.getRoot().getUuid());
            return set;
        }
    }
}

