/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula.coverage;

import java.util.Objects;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.CoverageUtils;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.ElementsAndCoveredElementsVariationCounter;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.SingleWithUncoveredMetricKeys;

public final class SingleWithUncoveredVariationCounter
extends ElementsAndCoveredElementsVariationCounter {
    private final SingleWithUncoveredMetricKeys metricKeys;

    public SingleWithUncoveredVariationCounter(SingleWithUncoveredMetricKeys metricKeys) {
        this.metricKeys = Objects.requireNonNull(metricKeys);
    }

    @Override
    protected void initializeForSupportedLeaf(CounterInitializationContext counterContext) {
        long newConditions = (long)CoverageUtils.getMeasureVariations(counterContext, this.metricKeys.getCovered());
        long uncoveredConditions = (long)CoverageUtils.getMeasureVariations(counterContext, this.metricKeys.getUncovered());
        this.elements.increment(newConditions);
        this.coveredElements.increment(newConditions - uncoveredConditions);
    }
}

