/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.component.BranchType;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;

public class DefaultBranchImpl
implements Branch {
    private final String branchName;
    private final boolean isLegacyBranch;

    public DefaultBranchImpl() {
        this(null);
    }

    public DefaultBranchImpl(@Nullable String name) {
        this.isLegacyBranch = name != null;
        String string = this.branchName = name == null ? "master" : name;
        if (!ComponentKeys.isValidBranch((String)this.branchName)) {
            throw MessageException.of((String)String.format("\"%s\" is not a valid branch name. Allowed characters are alphanumeric, '-', '_', '.' and '/'.", this.branchName));
        }
    }

    @Override
    public BranchType getType() {
        return BranchType.LONG;
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public Optional<String> getMergeBranchUuid() {
        return Optional.empty();
    }

    @Override
    public boolean isLegacyFeature() {
        return this.isLegacyBranch;
    }

    @Override
    public String getName() {
        return this.branchName;
    }

    @Override
    public boolean supportsCrossProjectCpd() {
        return !this.isLegacyBranch;
    }

    @Override
    public String generateKey(ScannerReport.Component module, @Nullable ScannerReport.Component fileOrDir) {
        String moduleWithBranch = module.getKey();
        if (this.isLegacyBranch) {
            moduleWithBranch = ComponentKeys.createKey((String)module.getKey(), (String)this.branchName);
        }
        if (fileOrDir == null || StringUtils.isEmpty((String)fileOrDir.getPath())) {
            return moduleWithBranch;
        }
        return ComponentKeys.createEffectiveKey((String)moduleWithBranch, (String)StringUtils.trimToNull((String)fileOrDir.getPath()));
    }
}

