/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.index.ComponentIndex;
import org.sonar.server.component.index.ComponentQuery;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.util.LanguageParamUtils;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsComponents;
import org.sonarqube.ws.client.component.SearchWsRequest;

public class SearchAction
implements ComponentsWsAction {
    private final ComponentIndex componentIndex;
    private final DbClient dbClient;
    private final ResourceTypes resourceTypes;
    private final I18n i18n;
    private final Languages languages;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public SearchAction(ComponentIndex componentIndex, DbClient dbClient, ResourceTypes resourceTypes, I18n i18n, Languages languages, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.componentIndex = componentIndex;
        this.dbClient = dbClient;
        this.resourceTypes = resourceTypes;
        this.i18n = i18n;
        this.languages = languages;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setSince("6.3").setDescription("Search for components").addPagingParams(100).setResponseExample(this.getClass().getResource("search-components-example.json")).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>").setExampleValue((Object)"sonar");
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.3");
        action.createParam("language").setDescription("Language key. If provided, only components for the given language are returned.").setExampleValue((Object)LanguageParamUtils.getExampleValue(this.languages)).setPossibleValues(LanguageParamUtils.getLanguageKeys(this.languages));
        WsParameterBuilder.createQualifiersParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setRequired(true);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        WsComponents.SearchWsResponse searchWsResponse = this.doHandle(SearchAction.toSearchWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)searchWsResponse, wsRequest, wsResponse);
    }

    private static SearchWsRequest toSearchWsRequest(Request request) {
        return new SearchWsRequest().setOrganization(request.param("organization")).setQualifiers(request.mandatoryParamAsStrings("qualifiers")).setLanguage(request.param("language")).setQuery(request.param("q")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps"));
    }

    private WsComponents.SearchWsResponse doHandle(SearchWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.getOrganization(dbSession, request);
            ComponentQuery esQuery = SearchAction.buildEsQuery(organization, request);
            SearchIdResult<String> results = this.componentIndex.search(esQuery, new SearchOptions().setPage(request.getPage(), request.getPageSize()));
            List components = this.dbClient.componentDao().selectByUuids(dbSession, results.getIds());
            Map<String, String> projectKeysByUuids = this.searchProjectsKeysByUuids(dbSession, components);
            WsComponents.SearchWsResponse searchWsResponse = SearchAction.buildResponse(components, organization, projectKeysByUuids, Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal((int)results.getTotal()));
            return searchWsResponse;
        }
    }

    private Map<String, String> searchProjectsKeysByUuids(DbSession dbSession, List<ComponentDto> components) {
        Set projectUuidsToSearch = (Set)components.stream().map(ComponentDto::projectUuid).collect(MoreCollectors.toHashSet());
        List projects = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)projectUuidsToSearch);
        return projects.stream().collect(Collectors.toMap(ComponentDto::uuid, ComponentDto::getDbKey));
    }

    private OrganizationDto getOrganization(DbSession dbSession, SearchWsRequest request) {
        String organizationKey = Optional.ofNullable(request.getOrganization()).orElseGet(this.defaultOrganizationProvider.get()::getKey);
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organizationDto with key '%s'", organizationKey);
    }

    private static ComponentQuery buildEsQuery(OrganizationDto organization, SearchWsRequest request) {
        return ComponentQuery.builder().setQuery(request.getQuery()).setOrganization(organization.getUuid()).setLanguage(request.getLanguage()).setQualifiers(request.getQualifiers()).build();
    }

    private static WsComponents.SearchWsResponse buildResponse(List<ComponentDto> components, OrganizationDto organization, Map<String, String> projectKeysByUuids, Paging paging) {
        WsComponents.SearchWsResponse.Builder responseBuilder = WsComponents.SearchWsResponse.newBuilder();
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        components.stream().map(dto -> SearchAction.dtoToComponent(organization, dto, (String)projectKeysByUuids.get(dto.projectUuid()))).forEach(arg_0 -> ((WsComponents.SearchWsResponse.Builder)responseBuilder).addComponents(arg_0));
        return responseBuilder.build();
    }

    private static WsComponents.Component dtoToComponent(OrganizationDto organization, ComponentDto dto, String projectKey) {
        Preconditions.checkArgument((boolean)organization.getUuid().equals(dto.getOrganizationUuid()), (String)"No Organization found for uuid '%s'", (Object[])new Object[]{dto.getOrganizationUuid()});
        WsComponents.Component.Builder builder = WsComponents.Component.newBuilder().setOrganization(organization.getKey()).setId(dto.uuid()).setKey(dto.getDbKey()).setProject(projectKey).setName(dto.name()).setQualifier(dto.qualifier());
        Protobuf.setNullable((Object)dto.language(), arg_0 -> ((WsComponents.Component.Builder)builder).setLanguage(arg_0));
        return builder.build();
    }
}

