/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.sonar.core.util.stream.MoreCollectors;

public class ComponentHit {
    private final String uuid;
    private final Optional<String> highlightedText;

    public ComponentHit(String uuid) {
        this.uuid = uuid;
        this.highlightedText = Optional.empty();
    }

    public ComponentHit(SearchHit hit) {
        this.uuid = hit.getId();
        this.highlightedText = ComponentHit.getHighlightedText(hit);
    }

    private static Optional<String> getHighlightedText(SearchHit hit) {
        return Optional.ofNullable(hit.getHighlightFields()).flatMap(fields -> Optional.ofNullable(fields.get("name"))).flatMap(field -> Optional.ofNullable(field.getFragments())).flatMap(fragments -> Arrays.stream(fragments).findFirst()).map(Text::string);
    }

    public String getUuid() {
        return this.uuid;
    }

    public static List<ComponentHit> fromSearchHits(SearchHit ... hits) {
        return (List)Arrays.stream(hits).map(ComponentHit::new).collect(MoreCollectors.toList((int)hits.length));
    }

    public Optional<String> getHighlightedText() {
        return this.highlightedText;
    }
}

