/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import java.util.Collections;
import org.sonar.api.server.ServerSide;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentKeyUpdaterDao;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class ComponentService {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ProjectIndexers projectIndexers;

    public ComponentService(DbClient dbClient, UserSession userSession, ProjectIndexers projectIndexers) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.projectIndexers = projectIndexers;
    }

    public void updateKey(DbSession dbSession, ComponentDto projectOrModule, String newKey) {
        this.userSession.checkComponentPermission("admin", projectOrModule);
        ComponentKeyUpdaterDao.checkIsProjectOrModule((ComponentDto)projectOrModule);
        ComponentService.checkProjectOrModuleKeyFormat(newKey);
        this.dbClient.componentKeyUpdaterDao().updateKey(dbSession, projectOrModule.uuid(), newKey);
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(projectOrModule), ProjectIndexer.Cause.PROJECT_KEY_UPDATE);
    }

    public void bulkUpdateKey(DbSession dbSession, ComponentDto projectOrModule, String stringToReplace, String replacementString) {
        this.dbClient.componentKeyUpdaterDao().bulkUpdateKey(dbSession, projectOrModule.uuid(), stringToReplace, replacementString);
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(projectOrModule), ProjectIndexer.Cause.PROJECT_KEY_UPDATE);
    }

    private static void checkProjectOrModuleKeyFormat(String key) {
        WsUtils.checkRequest(ComponentKeys.isValidModuleKey((String)key), "Malformed key for '%s'. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", key);
    }
}

