/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.taskprocessor.CeTaskProcessor;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeQueueDto;
import org.sonar.db.ce.CeTaskQuery;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.ce.ws.TaskFormatter;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.WsCe;
import org.sonarqube.ws.client.ce.ActivityWsRequest;

public class ActivityAction
implements CeWsAction {
    private static final int MAX_PAGE_SIZE = 1000;
    private static final String[] POSSIBLE_QUALIFIERS = new String[]{"TRK", "APP", "VW", "DEV", "BRC"};
    private final UserSession userSession;
    private final DbClient dbClient;
    private final TaskFormatter formatter;
    private final Set<String> taskTypes;

    public ActivityAction(UserSession userSession, DbClient dbClient, TaskFormatter formatter, CeTaskProcessor[] taskProcessors) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.formatter = formatter;
        this.taskTypes = new LinkedHashSet<String>();
        for (CeTaskProcessor taskProcessor : taskProcessors) {
            this.taskTypes.addAll(taskProcessor.getHandledCeTaskTypes());
        }
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("activity").setDescription(String.format("Search for tasks.<br> Requires the system administration permission, or project administration permission if %s is set.", "componentId")).setResponseExample(this.getClass().getResource("activity-example.json")).setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("5.5", "it's no more possible to specify the page parameter."), new Change("6.1", "field \"logs\" is deprecated and its value is always false"), new Change("6.6", "fields \"branch\" and \"branchType\" added")}).setSince("5.2");
        action.createParam("componentId").setDescription("Id of the component (project) to filter on").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL0");
        action.createParam("componentQuery").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li></ul>Must not be set together with %s.<br />Deprecated and replaced by '%s'", "componentId", "q")).setExampleValue((Object)"Apache").setDeprecatedSince("5.5");
        action.createParam("q").setDescription(String.format("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that are exactly the same as the supplied string</li><li>task ids that are exactly the same as the supplied string</li></ul>Must not be set together with %s", "componentId")).setExampleValue((Object)"Apache").setSince("5.5");
        action.createParam("status").setDescription("Comma separated list of task statuses").setPossibleValues((Collection)ImmutableList.builder().add((Object[])CeActivityDto.Status.values()).add((Object[])CeQueueDto.Status.values()).build()).setExampleValue((Object)Joiner.on((String)",").join((Object)CeQueueDto.Status.IN_PROGRESS, (Object)CeActivityDto.Status.SUCCESS, new Object[0])).setDefaultValue((Object)Joiner.on((String)",").join((Object[])CeActivityDto.Status.values()));
        action.createParam("onlyCurrents").setDescription("Filter on the last tasks (only the most recent finished task by project)").setBooleanPossibleValues().setDefaultValue((Object)"false");
        action.createParam("type").setDescription("Task type").setExampleValue((Object)"REPORT").setPossibleValues(this.taskTypes);
        action.createParam("minSubmittedAt").setDescription("Minimum date of task submission (inclusive)").setExampleValue((Object)DateUtils.formatDateTime((Date)new Date()));
        action.createParam("maxExecutedAt").setDescription("Maximum date of end of task processing (inclusive)").setExampleValue((Object)DateUtils.formatDateTime((Date)new Date()));
        action.createParam("p").setDescription("Deprecated parameter").setDeprecatedSince("5.5").setDeprecatedKey("pageIndex", "5.4");
        action.createPageSize(100, 1000);
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        WsCe.ActivityResponse activityResponse = this.doHandle(ActivityAction.toSearchWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)activityResponse, wsRequest, wsResponse);
    }

    private WsCe.ActivityResponse doHandle(ActivityWsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.checkPermission(component);
            com.google.common.base.Optional<WsCe.Task> taskSearchedById = this.searchTaskByUuid(dbSession, request);
            if (taskSearchedById.isPresent()) {
                WsCe.ActivityResponse activityResponse = ActivityAction.buildResponse(Collections.singletonList(taskSearchedById.get()), Collections.emptyList(), request.getPageSize());
                return activityResponse;
            }
            CeTaskQuery query = this.buildQuery(dbSession, request, component);
            List<WsCe.Task> queuedTasks = this.loadQueuedTasks(dbSession, request, query);
            List<WsCe.Task> pastTasks = this.loadPastTasks(dbSession, request, query);
            WsCe.ActivityResponse activityResponse = ActivityAction.buildResponse(queuedTasks, pastTasks, request.getPageSize());
            return activityResponse;
        }
    }

    @CheckForNull
    private ComponentDto loadComponent(DbSession dbSession, ActivityWsRequest request) {
        String componentId = request.getComponentId();
        if (componentId == null) {
            return null;
        }
        return (ComponentDto)WsUtils.checkFoundWithOptional(this.dbClient.componentDao().selectByUuid(dbSession, componentId), "Component '%s' does not exist", componentId);
    }

    private void checkPermission(@Nullable ComponentDto component) {
        this.userSession.checkLoggedIn();
        if (component == null) {
            this.userSession.checkIsSystemAdministrator();
        } else {
            this.userSession.checkComponentPermission("admin", component);
        }
    }

    private com.google.common.base.Optional<WsCe.Task> searchTaskByUuid(DbSession dbSession, ActivityWsRequest request) {
        String textQuery = request.getQuery();
        if (textQuery == null) {
            return com.google.common.base.Optional.absent();
        }
        Optional queue = this.dbClient.ceQueueDao().selectByUuid(dbSession, textQuery);
        if (queue.isPresent()) {
            return com.google.common.base.Optional.of((Object)this.formatter.formatQueue(dbSession, (CeQueueDto)queue.get()));
        }
        Optional activity = this.dbClient.ceActivityDao().selectByUuid(dbSession, textQuery);
        return activity.map(ceActivityDto -> com.google.common.base.Optional.of((Object)this.formatter.formatActivity(dbSession, (CeActivityDto)ceActivityDto, null))).orElseGet(com.google.common.base.Optional::absent);
    }

    private CeTaskQuery buildQuery(DbSession dbSession, ActivityWsRequest request, @Nullable ComponentDto component) {
        CeTaskQuery query = new CeTaskQuery();
        query.setType(request.getType());
        query.setOnlyCurrents(request.getOnlyCurrents().booleanValue());
        Date minSubmittedAt = DateUtils.parseStartingDateOrDateTime((String)request.getMinSubmittedAt());
        query.setMinSubmittedAt(minSubmittedAt == null ? null : Long.valueOf(minSubmittedAt.getTime()));
        Date maxExecutedAt = DateUtils.parseEndingDateOrDateTime((String)request.getMaxExecutedAt());
        query.setMaxExecutedAt(maxExecutedAt == null ? null : Long.valueOf(maxExecutedAt.getTime()));
        List statuses = request.getStatus();
        if (statuses != null && !statuses.isEmpty()) {
            query.setStatuses(request.getStatus());
        }
        String componentQuery = request.getQuery();
        if (component != null) {
            query.setComponentUuid(component.uuid());
        } else if (componentQuery != null) {
            query.setComponentUuids((List)this.loadComponents(dbSession, componentQuery).stream().map(ComponentDto::uuid).collect(MoreCollectors.toList()));
        }
        return query;
    }

    private List<ComponentDto> loadComponents(DbSession dbSession, String componentQuery) {
        ComponentQuery componentDtoQuery = ComponentQuery.builder().setNameOrKeyQuery(componentQuery).setQualifiers(POSSIBLE_QUALIFIERS).build();
        return this.dbClient.componentDao().selectByQuery(dbSession, componentDtoQuery, 0, 1000);
    }

    private List<WsCe.Task> loadQueuedTasks(DbSession dbSession, ActivityWsRequest request, CeTaskQuery query) {
        List dtos = this.dbClient.ceQueueDao().selectByQueryInDescOrder(dbSession, query, request.getPageSize().intValue());
        return this.formatter.formatQueue(dbSession, dtos);
    }

    private List<WsCe.Task> loadPastTasks(DbSession dbSession, ActivityWsRequest request, CeTaskQuery query) {
        List dtos = this.dbClient.ceActivityDao().selectByQuery(dbSession, query, Pagination.forPage((int)1).andSize(request.getPageSize().intValue()));
        return this.formatter.formatActivity(dbSession, dtos);
    }

    private static WsCe.ActivityResponse buildResponse(Iterable<WsCe.Task> queuedTasks, Iterable<WsCe.Task> pastTasks, int pageSize) {
        WsCe.ActivityResponse.Builder wsResponseBuilder = WsCe.ActivityResponse.newBuilder();
        int nbInsertedTasks = 0;
        for (WsCe.Task queuedTask : queuedTasks) {
            if (nbInsertedTasks >= pageSize) continue;
            wsResponseBuilder.addTasks(queuedTask);
            ++nbInsertedTasks;
        }
        for (WsCe.Task pastTask : pastTasks) {
            if (nbInsertedTasks >= pageSize) continue;
            wsResponseBuilder.addTasks(pastTask);
            ++nbInsertedTasks;
        }
        return wsResponseBuilder.build();
    }

    private static ActivityWsRequest toSearchWsRequest(Request request) {
        ActivityWsRequest activityWsRequest = new ActivityWsRequest().setComponentId(request.param("componentId")).setQuery(StringUtils.defaultString((String)request.param("q"), (String)request.param("componentQuery"))).setStatus(request.paramAsStrings("status")).setType(request.param("type")).setMinSubmittedAt(request.param("minSubmittedAt")).setMaxExecutedAt(request.param("maxExecutedAt")).setOnlyCurrents(request.paramAsBoolean("onlyCurrents")).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps")));
        WsUtils.checkRequest(activityWsRequest.getComponentId() == null || activityWsRequest.getQuery() == null, "%s and %s must not be set at the same time", "componentId", "componentQuery");
        WsUtils.checkRequest(activityWsRequest.getPageSize() <= 1000, "The '%s' parameter must be less than %d", "ps", 1000);
        return activityWsRequest;
    }
}

