/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.web.ServletFilter;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.AuthenticationError;
import org.sonar.server.authentication.Authenticators;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserSessionFactory;

@ServerSide
public class UserSessionInitializer {
    private static final String ACCESS_LOG_LOGIN = "LOGIN";
    private static final Set<String> SKIPPED_URLS = ImmutableSet.of((Object)"/batch/index", (Object)"/batch/file", (Object)"/maintenance/*", (Object)"/setup/*", (Object)"/sessions/*", (Object)"/oauth2/callback/*", (Object[])new String[]{"/api/system/db_migration_status", "/api/system/status", "/api/system/migrate_db", "/api/server/version", "/api/users/identity_providers", "/api/l10n/index", "/api/authentication/login", "/api/authentication/logout", "/api/authentication/validate"});
    private static final ServletFilter.UrlPattern URL_PATTERN = ServletFilter.UrlPattern.builder().includes(new String[]{"/*"}).excludes(ServletFilter.UrlPattern.Builder.staticResourcePatterns()).excludes(SKIPPED_URLS).build();
    private final Configuration config;
    private final ThreadLocalUserSession threadLocalSession;
    private final AuthenticationEvent authenticationEvent;
    private final UserSessionFactory userSessionFactory;
    private final Authenticators authenticators;

    public UserSessionInitializer(Configuration config, ThreadLocalUserSession threadLocalSession, AuthenticationEvent authenticationEvent, UserSessionFactory userSessionFactory, Authenticators authenticators) {
        this.config = config;
        this.threadLocalSession = threadLocalSession;
        this.authenticationEvent = authenticationEvent;
        this.userSessionFactory = userSessionFactory;
        this.authenticators = authenticators;
    }

    public boolean initUserSession(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getRequestURI().replaceFirst(request.getContextPath(), "");
        try {
            if (URL_PATTERN.matches(path)) {
                this.loadUserSession(request, response);
            }
            return true;
        }
        catch (AuthenticationException e) {
            this.authenticationEvent.loginFailure(request, e);
            if (UserSessionInitializer.isWsUrl(path)) {
                response.setStatus(401);
                return false;
            }
            if (UserSessionInitializer.isNotLocalOrJwt(e.getSource())) {
                AuthenticationError.handleAuthenticationError(e, response, request.getContextPath());
                return false;
            }
            return true;
        }
    }

    private static boolean isNotLocalOrJwt(AuthenticationEvent.Source source) {
        AuthenticationEvent.Provider provider = source.getProvider();
        return provider != AuthenticationEvent.Provider.LOCAL && provider != AuthenticationEvent.Provider.JWT;
    }

    private void loadUserSession(HttpServletRequest request, HttpServletResponse response) {
        UserSession session;
        Optional<UserDto> user = this.authenticators.authenticate(request, response);
        if (user.isPresent()) {
            session = this.userSessionFactory.create(user.get());
        } else {
            this.failIfAuthenticationIsRequired();
            session = this.userSessionFactory.createAnonymous();
        }
        this.threadLocalSession.set(session);
        request.setAttribute(ACCESS_LOG_LOGIN, (Object)StringUtils.defaultString((String)session.getLogin(), (String)"-"));
    }

    private void failIfAuthenticationIsRequired() {
        if (this.config.getBoolean("sonar.forceAuthentication").orElse(false).booleanValue()) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.BASIC)).setMessage("User must be authenticated").build();
        }
    }

    public void removeUserSession() {
        this.threadLocalSession.unload();
    }

    private static boolean isWsUrl(String path) {
        return path.startsWith("/batch/") || path.startsWith("/api/");
    }
}

