/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.authentication.Cookies;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class JwtCsrfVerifier {
    private static final String CSRF_STATE_COOKIE = "XSRF-TOKEN";
    private static final String CSRF_HEADER = "X-XSRF-TOKEN";
    private static final Set<String> UPDATE_METHODS = ImmutableSet.of((Object)"POST", (Object)"PUT", (Object)"DELETE");
    private static final String API_URL = "/api";

    public String generateState(HttpServletRequest request, HttpServletResponse response, int timeoutInSeconds) {
        String state = new BigInteger(130, new SecureRandom()).toString(32);
        response.addCookie(Cookies.newCookieBuilder(request).setName(CSRF_STATE_COOKIE).setValue(state).setHttpOnly(false).setExpiry(timeoutInSeconds).build());
        return state;
    }

    public void verifyState(HttpServletRequest request, @Nullable String csrfState, @Nullable String login) {
        if (!JwtCsrfVerifier.shouldRequestBeChecked(request)) {
            return;
        }
        String failureCause = JwtCsrfVerifier.checkCsrf(csrfState, request.getHeader(CSRF_HEADER));
        if (failureCause != null) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(AuthenticationEvent.Method.JWT)).setLogin(login).setMessage(failureCause).build();
        }
    }

    @CheckForNull
    private static String checkCsrf(@Nullable String csrfState, @Nullable String stateInHeader) {
        if (StringUtils.isBlank((String)csrfState)) {
            return "Missing reference CSRF value";
        }
        if (!StringUtils.equals((String)csrfState, (String)stateInHeader)) {
            return "Wrong CSFR in request";
        }
        return null;
    }

    public void refreshState(HttpServletRequest request, HttpServletResponse response, String csrfState, int timeoutInSeconds) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(CSRF_STATE_COOKIE).setValue(csrfState).setHttpOnly(false).setExpiry(timeoutInSeconds).build());
    }

    public void removeState(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(CSRF_STATE_COOKIE).setValue(null).setHttpOnly(false).setExpiry(0).build());
    }

    private static boolean shouldRequestBeChecked(HttpServletRequest request) {
        if (UPDATE_METHODS.contains(request.getMethod())) {
            String path = request.getRequestURI().replaceFirst(request.getContextPath(), "");
            return path.startsWith(API_URL);
        }
        return false;
    }
}

