/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.authentication.event.AuthenticationException;

final class AuthenticationError {
    private static final String UNAUTHORIZED_PATH = "/sessions/unauthorized";
    private static final String UNAUTHORIZED_PATH_WITH_MESSAGE = "/sessions/unauthorized?message=%s";
    private static final Logger LOGGER = Loggers.get(AuthenticationError.class);

    private AuthenticationError() {
    }

    static void handleError(Exception e, HttpServletResponse response, String message) {
        LOGGER.error(message, (Throwable)e);
        AuthenticationError.redirectToUnauthorized(response);
    }

    static void handleError(HttpServletResponse response, String message) {
        LOGGER.error(message);
        AuthenticationError.redirectToUnauthorized(response);
    }

    static void handleAuthenticationError(AuthenticationException e, HttpServletResponse response, String contextPath) {
        AuthenticationError.redirectTo(response, AuthenticationError.getPath(e, contextPath));
    }

    private static String getPath(AuthenticationException e, String contextPath) {
        String publicMessage = e.getPublicMessage();
        if (publicMessage == null || publicMessage.isEmpty()) {
            return UNAUTHORIZED_PATH;
        }
        return contextPath + String.format(UNAUTHORIZED_PATH_WITH_MESSAGE, AuthenticationError.encodeMessage(publicMessage));
    }

    private static String encodeMessage(String message) {
        try {
            return URLEncoder.encode(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(String.format("Fail to encode %s", message), e);
        }
    }

    public static void redirectToUnauthorized(HttpServletResponse response) {
        AuthenticationError.redirectTo(response, UNAUTHORIZED_PATH);
    }

    private static void redirectTo(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to redirect to %s", url), e);
        }
    }
}

