/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.source;

import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.scanner.sensor.DefaultSensorStorage;
import org.sonar.scanner.source.DeprecatedDefaultSymbolTable;

public class DefaultSymbolizable
implements Symbolizable {
    private static final NoOpSymbolTableBuilder NO_OP_SYMBOL_TABLE_BUILDER = new NoOpSymbolTableBuilder();
    private static final NoOpSymbolTable NO_OP_SYMBOL_TABLE = new NoOpSymbolTable();
    private static final NoOpSymbol NO_OP_SYMBOL = new NoOpSymbol();
    private final InputFile inputFile;
    private final DefaultSensorStorage sensorStorage;
    private final AnalysisMode analysisMode;

    public DefaultSymbolizable(InputFile inputFile, DefaultSensorStorage sensorStorage, AnalysisMode analysisMode) {
        this.inputFile = inputFile;
        this.sensorStorage = sensorStorage;
        this.analysisMode = analysisMode;
    }

    public Symbolizable.SymbolTableBuilder newSymbolTableBuilder() {
        if (this.analysisMode.isIssues()) {
            return NO_OP_SYMBOL_TABLE_BUILDER;
        }
        return new DeprecatedDefaultSymbolTable.Builder(new DefaultSymbolTable((SensorStorage)this.sensorStorage).onFile(this.inputFile));
    }

    public void setSymbolTable(Symbolizable.SymbolTable symbolTable) {
        if (this.analysisMode.isIssues()) {
            return;
        }
        ((DeprecatedDefaultSymbolTable)symbolTable).getWrapped().save();
    }

    private static final class NoOpSymbol
    implements Symbol {
        private NoOpSymbol() {
        }

        public String getFullyQualifiedName() {
            return null;
        }

        public int getDeclarationStartOffset() {
            return 0;
        }

        public int getDeclarationEndOffset() {
            return 0;
        }
    }

    private static final class NoOpSymbolTable
    implements Symbolizable.SymbolTable {
        private NoOpSymbolTable() {
        }

        public List<Symbol> symbols() {
            return Collections.emptyList();
        }

        public List<Integer> references(Symbol symbol) {
            return Collections.emptyList();
        }
    }

    private static final class NoOpSymbolTableBuilder
    implements Symbolizable.SymbolTableBuilder {
        private NoOpSymbolTableBuilder() {
        }

        public Symbol newSymbol(int fromOffset, int toOffset) {
            return NO_OP_SYMBOL;
        }

        public Symbol newSymbol(int startLine, int startLineOffset, int endLine, int endLineOffset) {
            return NO_OP_SYMBOL;
        }

        public void newReference(Symbol symbol, int fromOffset) {
        }

        public void newReference(Symbol symbol, int fromOffset, int toOffset) {
        }

        public void newReference(Symbol symbol, int startLine, int startLineOffset, int endLine, int endLineOffset) {
        }

        public Symbolizable.SymbolTable build() {
            return NO_OP_SYMBOL_TABLE;
        }
    }
}

