/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.report;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputComponentTree;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.report.Reporter;

@Properties(value={@Property(key="sonar.report.export.path", name="Report Results Export File", type=PropertyType.STRING, global=false, project=false)})
public class JSONReport
implements Reporter {
    static final String SONAR_REPORT_EXPORT_PATH = "sonar.report.export.path";
    private static final Logger LOG = LoggerFactory.getLogger(JSONReport.class);
    private final Configuration settings;
    private final FileSystem fileSystem;
    private final Server server;
    private final Rules rules;
    private final IssueCache issueCache;
    private final InputComponentStore componentStore;
    private final DefaultInputModule rootModule;
    private final InputModuleHierarchy moduleHierarchy;
    private final InputComponentTree inputComponentTree;

    public JSONReport(InputModuleHierarchy moduleHierarchy, Configuration settings, FileSystem fileSystem, Server server, Rules rules, IssueCache issueCache, DefaultInputModule rootModule, InputComponentStore componentStore, InputComponentTree inputComponentTree) {
        this.moduleHierarchy = moduleHierarchy;
        this.settings = settings;
        this.fileSystem = fileSystem;
        this.server = server;
        this.rules = rules;
        this.issueCache = issueCache;
        this.rootModule = rootModule;
        this.componentStore = componentStore;
        this.inputComponentTree = inputComponentTree;
    }

    @Override
    public void execute() {
        this.settings.get(SONAR_REPORT_EXPORT_PATH).ifPresent(this::exportResults);
    }

    private void exportResults(String exportPath) {
        File exportFile = new File(this.fileSystem.workDir(), exportPath);
        LOG.info("Export issues to {}", (Object)exportFile.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            this.writeJson(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write report results in file " + exportFile.getAbsolutePath(), e);
        }
    }

    @VisibleForTesting
    void writeJson(Writer writer) {
        try (JsonWriter json = JsonWriter.of((Writer)writer);){
            json.beginObject();
            json.prop("version", this.server.getVersion());
            LinkedHashSet<RuleKey> ruleKeys = new LinkedHashSet<RuleKey>();
            LinkedHashSet<String> userLogins = new LinkedHashSet<String>();
            this.writeJsonIssues(json, ruleKeys, userLogins);
            this.writeJsonComponents(json);
            this.writeJsonRules(json, ruleKeys);
            JSONReport.writeUsers(json, userLogins);
            json.endObject();
        }
    }

    private void writeJsonIssues(JsonWriter json, Set<RuleKey> ruleKeys, Set<String> logins) {
        json.name("issues").beginArray();
        for (TrackedIssue issue : this.getIssues()) {
            if (issue.resolution() != null) continue;
            InputComponent component = this.componentStore.getByKey(issue.componentKey());
            String componentKey = this.getModule(component).definition().getKeyWithBranch();
            if (component instanceof InputPath) {
                componentKey = ComponentKeys.createEffectiveKey((String)componentKey, (InputPath)((InputPath)component));
            }
            json.beginObject().prop("key", issue.key()).prop("component", componentKey).prop("line", (Number)issue.startLine()).prop("startLine", (Number)issue.startLine()).prop("startOffset", (Number)issue.startLineOffset()).prop("endLine", (Number)issue.endLine()).prop("endOffset", (Number)issue.endLineOffset()).prop("message", issue.getMessage()).prop("severity", issue.severity()).prop("rule", issue.getRuleKey().toString()).prop("status", issue.status()).prop("resolution", issue.resolution()).prop("isNew", issue.isNew()).prop("assignee", issue.assignee()).prop("effortToFix", (Number)issue.gap()).propDateTime("creationDate", issue.creationDate());
            if (!StringUtils.isEmpty((String)issue.assignee())) {
                logins.add(issue.assignee());
            }
            json.endObject();
            ruleKeys.add(issue.getRuleKey());
        }
        json.endArray();
    }

    private DefaultInputModule getModule(InputComponent component) {
        if (component.isFile()) {
            return (DefaultInputModule)this.inputComponentTree.getParent(this.inputComponentTree.getParent(component));
        }
        if (component instanceof InputDir) {
            return (DefaultInputModule)this.inputComponentTree.getParent(component);
        }
        return (DefaultInputModule)component;
    }

    private void writeJsonComponents(JsonWriter json) {
        String key;
        String moduleKey;
        json.name("components").beginArray();
        this.writeJsonModuleComponents(json, this.rootModule);
        for (DefaultInputFile inputFile : this.componentStore.allFilesToPublish()) {
            moduleKey = this.getModule((InputComponent)inputFile).definition().getKeyWithBranch();
            key = ComponentKeys.createEffectiveKey((String)moduleKey, (InputPath)inputFile);
            json.beginObject().prop("key", key).prop("path", inputFile.relativePath()).prop("moduleKey", moduleKey).prop("status", inputFile.status().name()).endObject();
        }
        for (InputDir inputDir : this.componentStore.allDirs()) {
            moduleKey = this.getModule((InputComponent)inputDir).definition().getKeyWithBranch();
            key = ComponentKeys.createEffectiveKey((String)moduleKey, (InputPath)inputDir);
            json.beginObject().prop("key", key).prop("path", inputDir.relativePath()).prop("moduleKey", moduleKey).endObject();
        }
        json.endArray();
    }

    private void writeJsonModuleComponents(JsonWriter json, DefaultInputModule module) {
        json.beginObject().prop("key", module.definition().getKeyWithBranch()).prop("path", this.moduleHierarchy.relativePath((InputModule)module)).endObject();
        for (DefaultInputModule subModule : this.moduleHierarchy.children((InputModule)module)) {
            this.writeJsonModuleComponents(json, subModule);
        }
    }

    private void writeJsonRules(JsonWriter json, Set<RuleKey> ruleKeys) {
        json.name("rules").beginArray();
        for (RuleKey ruleKey : ruleKeys) {
            json.beginObject().prop("key", ruleKey.toString()).prop("rule", ruleKey.rule()).prop("repository", ruleKey.repository()).prop("name", this.getRuleName(ruleKey)).endObject();
        }
        json.endArray();
    }

    private static void writeUsers(JsonWriter json, Collection<String> userLogins) {
        json.name("users").beginArray();
        for (String user : userLogins) {
            json.beginObject().prop("login", user).prop("name", user).endObject();
        }
        json.endArray();
    }

    private String getRuleName(RuleKey ruleKey) {
        Rule rule = this.rules.find(ruleKey);
        return rule != null ? rule.name() : null;
    }

    @VisibleForTesting
    Iterable<TrackedIssue> getIssues() {
        return this.issueCache.all();
    }
}

