/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.measure;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.measure.MetricFinder;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.scanner.scan.measure.MeasureValueCoder;
import org.sonar.scanner.storage.Storage;
import org.sonar.scanner.storage.Storages;

@ScannerSide
public class MeasureCache {
    private final Storage<DefaultMeasure<?>> cache;

    public MeasureCache(Storages caches, MetricFinder metricFinder) {
        caches.registerValueCoder(DefaultMeasure.class, new MeasureValueCoder(metricFinder));
        this.cache = caches.createCache("measures");
    }

    public Iterable<Storage.Entry<DefaultMeasure<?>>> entries() {
        return this.cache.entries();
    }

    public Iterable<DefaultMeasure<?>> all() {
        return this.cache.values();
    }

    public Iterable<DefaultMeasure<?>> byComponentKey(String effectiveKey) {
        return this.cache.values(effectiveKey);
    }

    @CheckForNull
    public DefaultMeasure<?> byMetric(String componentKey, String metricKey) {
        return this.cache.get(componentKey, metricKey);
    }

    public MeasureCache put(String componentKey, String metricKey, DefaultMeasure<?> measure) {
        Preconditions.checkNotNull((Object)componentKey);
        Preconditions.checkNotNull((Object)metricKey);
        this.cache.put(componentKey, metricKey, measure);
        return this;
    }

    public boolean contains(String componentKey, String metricKey) {
        Preconditions.checkNotNull((Object)componentKey);
        Preconditions.checkNotNull((Object)metricKey);
        return this.cache.containsKey(componentKey, metricKey);
    }
}

