/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.measure;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.scanner.repository.MetricsRepository;

public final class DeprecatedMetricFinder
implements MetricFinder {
    private Map<String, Metric> metricsByKey = new LinkedHashMap<String, Metric>();
    private Map<Integer, Metric> metricsById = new LinkedHashMap<Integer, Metric>();

    public DeprecatedMetricFinder(MetricsRepository metricsRepository) {
        for (Metric metric : metricsRepository.metrics()) {
            this.metricsByKey.put(metric.key(), metric);
            this.metricsById.put(metric.getId(), metric);
        }
    }

    public Metric findById(int metricId) {
        return this.metricsById.get(metricId);
    }

    public Metric findByKey(String key) {
        return this.metricsByKey.get(key);
    }

    public Collection<Metric> findAll(List<String> metricKeys) {
        LinkedList<Metric> result = new LinkedList<Metric>();
        for (String metricKey : metricKeys) {
            Metric metric = this.findByKey(metricKey);
            if (metric == null) continue;
            result.add(metric);
        }
        return result;
    }

    public Collection<Metric> findAll() {
        return this.metricsByKey.values();
    }
}

